/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.HeartbeatWatcher;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class HeartbeatWatcherTest {
    @Test
    public void testReceptionCallback() throws IOException {
        HeartbeatWatcher watcher = new HeartbeatWatcher();
        Assert.assertNotNull((Object)watcher.createMetricsReceptionCallback());
        Assert.assertNotNull((Object)watcher.createStatusReceptionCallback());
        TransportConnector conn = TransportFactory.createDirectMemoryConnector();
        watcher.installInto(conn);
        watcher.uninstallFrom(conn);
    }

    @Test
    public void testWatcher() {
        HeartbeatWatcher watcher = new HeartbeatWatcher();
        long orig = watcher.setTimeout(1000L);
        String dev1 = "0ab1234c1";
        String dev2 = "0ab2234c3";
        watcher.notifyRecordReceived("0ab1234c1");
        Assert.assertEquals((long)1L, (long)watcher.getDeviceCount());
        TimeUtils.sleep((int)200);
        watcher.notifyRecordReceived("0ab2234c3");
        Assert.assertEquals((long)2L, (long)watcher.getDeviceCount());
        TimeUtils.sleep((int)200);
        watcher.notifyRecordReceived("0ab2234c3");
        Assert.assertEquals((long)2L, (long)watcher.getDeviceCount());
        TimeUtils.sleep((int)200);
        watcher.notifyRecordReceived("0ab2234c3");
        TimeUtils.sleep((int)200);
        watcher.notifyRecordReceived("0ab2234c3");
        TimeUtils.sleep((int)200);
        watcher.notifyRecordReceived("0ab2234c3");
        TimeUtils.sleep((int)200);
        Assert.assertEquals((long)2L, (long)watcher.getDeviceCount());
        watcher.deleteOutdated(d -> Assert.assertEquals((Object)"0ab1234c1", (Object)d));
        Assert.assertEquals((long)1L, (long)watcher.getDeviceCount());
        watcher.clear();
        Assert.assertEquals((long)0L, (long)watcher.getDeviceCount());
        watcher.setTimeout(orig);
    }
}

