/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.PythonUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.AasCreator;
import test.de.iip_ecosphere.platform.services.environment.AbstractEnvironmentTest;
import test.de.iip_ecosphere.platform.services.environment.MyService;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class PythonEnvironmentTest
extends AbstractEnvironmentTest {
    @Before
    public void setup() {
        TestWithPlugin.setupAASPlugins();
        TestWithPlugin.loadPlugins();
    }

    private static void redirectIO(final InputStream src, final PrintStream dest, final Consumer<String> cons) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    dest.println(line);
                    if (null == cons) continue;
                    cons.accept(line);
                }
                sc.close();
            }
        }).start();
    }

    public static Process createPythonProcess(File dir, String ... args) throws IOException {
        return PythonEnvironmentTest.createPythonProcess(dir, null, null, args);
    }

    public static Process createPythonProcess(File dir, Consumer<String> stdCons, Consumer<String> errCons, String ... args) throws IOException {
        String pythonPath = PythonUtils.getPythonExecutable().toString();
        System.out.println("Using Python: " + pythonPath);
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(pythonPath);
        for (String a : args) {
            tmp.add(a);
        }
        System.out.println("Cmd line: " + String.valueOf(tmp));
        ProcessBuilder processBuilder = new ProcessBuilder(tmp);
        processBuilder.directory(dir);
        Process python = processBuilder.start();
        PythonEnvironmentTest.redirectIO(python.getInputStream(), System.out, stdCons);
        PythonEnvironmentTest.redirectIO(python.getErrorStream(), System.err, errCons);
        return python;
    }

    public static Process createPythonProcess(String ... args) throws IOException {
        return PythonEnvironmentTest.createPythonProcess(null, null, args);
    }

    public static Process createPythonProcess(Consumer<String> stdCons, Consumer<String> errCons, String ... args) throws IOException {
        return PythonEnvironmentTest.createPythonProcess(new File("./src/test/python"), stdCons, errCons, args);
    }

    @Test
    public void testPythonEnvironment() throws IOException, ExecutionException {
        this.testPythonEnvironment("");
    }

    private void testPythonEnvironment(String protocol) throws IOException, ExecutionException {
        ServerAddress vabServer = new ServerAddress(Schema.HTTP);
        ArrayList<String> args = new ArrayList<String>();
        args.add("__init__.py");
        args.add("--port");
        args.add(String.valueOf(vabServer.getPort()));
        if (protocol.length() > 0) {
            args.add("--protocol");
            args.add(protocol);
        }
        args.add("--metaModel");
        args.add(AasFactory.getInstance().getMetaModelVersion());
        args.add("--log=DEBUG");
        String[] tmp = new String[args.size()];
        AtomicBoolean started = new AtomicBoolean(false);
        Consumer<String> bindingConsumer = l -> started.set(l.contains("INFO:root:Bound to"));
        Process python = PythonEnvironmentTest.createPythonProcess(bindingConsumer, bindingConsumer, args.toArray(tmp));
        for (int count = 0; !started.get() && count < 20; ++count) {
            TimeUtils.sleep((int)200);
        }
        Assert.assertTrue((String)"Python server process not started", (boolean)started.get());
        ServerAddress aasServer = new ServerAddress(Schema.HTTP);
        Endpoint aasServerRegistry = new Endpoint(Schema.HTTP, "registry");
        BasicSetupSpec spec = new BasicSetupSpec(aasServerRegistry, aasServer);
        spec.setAssetServerAddress(vabServer, protocol);
        MyService service = new MyService();
        Aas aas = AasCreator.createAas((SetupSpec)spec, (Service)service);
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe((SetupSpec)spec).forRegistry().deploy(aas).createServer(new String[0]).start();
        AbstractEnvironmentTest.testAas((SetupSpec)spec, (Service)service);
        httpServer.stop(true);
        python.destroy();
    }
}

