/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.ServiceStub;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class StarterTest
extends TestWithPlugin {
    @Test
    public void testStarter() {
        String serviceId = "my Service - 1";
        StarterTest.assertStringContaining(Starter.getServiceCommandNetworkMgrKey((String)serviceId), serviceId);
        StarterTest.assertStringContaining(Starter.getServiceProcessNetworkMgrKey((String)serviceId), serviceId);
        int port = NetUtils.getEphemeralPort();
        Starter.parse((String[])new String[]{"file", "--myParam", Starter.composeArgument((String)"iip.protocol", (Object)""), Starter.composeArgument((String)"iip.port", (Object)port), Starter.composeArgument((String)Starter.getServicePortName((String)serviceId), (Object)12345), "--endParam"});
        Assert.assertNotNull((Object)Starter.getProtocolBuilder());
        Assert.assertEquals((long)12345L, (long)Starter.getServicePort((String)serviceId));
        Assert.assertEquals((long)-1L, (long)Starter.getServicePort((String)"unknown"));
        Starter.start();
        Starter.shutdown();
        Assert.assertNull((Object)Starter.getMappedService(null));
        Assert.assertNull((Object)Starter.getMappedService((String)"xcy"));
        Starter.setServiceAutostart((boolean)true);
        Starter.setOnServiceAutostartAttachShutdownHook((boolean)false);
        Starter.setOnServiceAutostartAttachShutdownHook((boolean)true);
        Starter.setServiceAutostart((boolean)false);
    }

    private static void assertString(String str) {
        Assert.assertNotNull((Object)str);
        Assert.assertTrue((str.length() > 0 ? 1 : 0) != 0);
    }

    private static void assertStringContaining(String str, String expected) {
        StarterTest.assertString(str);
        Assert.assertTrue((str.indexOf(expected) > 0 ? 1 : 0) != 0);
    }

    @Ignore(value="Needs rework for BaSyx2")
    @Test
    public void testFailingServiceCreation() {
        String protocol = "";
        int port = NetUtils.getEphemeralPort();
        Starter.main((String[])new String[]{Starter.composeArgument((String)"iip.protocol", (Object)""), Starter.composeArgument((String)"iip.port", (Object)String.valueOf(port))});
        boolean notifyOld = Starter.getSetup().getNotifyServiceNull();
        Starter.getSetup().setNotifyServiceNull(false);
        Starter.mapService(null);
        Starter.getSetup().setNotifyServiceNull(notifyOld);
        BasicSetupSpec spec = new BasicSetupSpec();
        spec.setAssetServerAddress(new ServerAddress(Schema.HTTP, port), "");
        InvocablesCreator iCreator = AasFactory.getInstance().createInvocablesCreator((SetupSpec)spec);
        ServiceStub stub = new ServiceStub(iCreator, "1234", new String[]{"service"});
        Assert.assertNull((Object)stub.getState());
        Assert.assertEquals((Object)"", (Object)stub.getDescription());
        Assert.assertEquals((Object)"", (Object)stub.getId());
        Assert.assertNull((Object)stub.getKind());
        Assert.assertNull((Object)stub.getVersion());
        Assert.assertFalse((boolean)stub.isDeployable());
        System.out.println("The following exception(s)/failing operations are intended!!!");
        try {
            stub.setState(ServiceState.ACTIVATING);
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            stub.activate();
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            stub.passivate();
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            stub.update(new File("").toURI());
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            stub.switchTo("id");
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        try {
            stub.reconfigure(new HashMap());
            Assert.fail();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

