/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentations;

import de.iip_ecosphere.platform.services.environment.metricsProvider.meterRepresentation.GaugeRepresentation;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MetricsFactory;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import de.iip_ecosphere.platform.support.metrics.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.metricsProvider.utils.TestUtils;

public class GaugeRepresentationTest {
    private static final String FOLDER = "gaugerepresentation";
    private static final String JSON_VALID = "validGauge.json";
    private static final String JSON_UPDATER = "jsonUpdater.json";
    private static final String JSON_INVALID_TWO_MEASUREMENTS = "invalidGaugeTwoMeasurements.json";
    private static final String JSON_INVALID_WRONG_STATISTIC = "invalidGaugeWrongStatistic.json";

    @Test
    public void testInitOkNoTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        double original = obj.getJsonArray("measurements").getJsonObject(0).getJsonNumber("value").doubleValue();
        ArrayList tagList = new ArrayList();
        Meter.Id id = MetricsFactory.buildId((String)obj.getString("name"), tagList, (String)obj.getString("baseUnit"), (String)obj.getString("description"), (Meter.Type)Meter.Type.GAUGE);
        Gauge gauge = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]);
        Assert.assertNotNull((Object)gauge);
        Assert.assertEquals((Object)id, (Object)gauge.getId());
        Assert.assertEquals((double)original, (double)gauge.value(), (double)0.0);
    }

    @Test
    public void testInitOkWithTags() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        double original = obj.getJsonArray("measurements").getJsonObject(0).getJsonNumber("value").doubleValue();
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        tagList.add(MetricsFactory.buildImmutableTag((String)"key1", (String)"value1"));
        tagList.add(MetricsFactory.buildImmutableTag((String)"key2", (String)"value2"));
        Meter.Id id = MetricsFactory.buildId((String)obj.getString("name"), tagList, (String)obj.getString("baseUnit"), (String)obj.getString("description"), (Meter.Type)Meter.Type.GAUGE);
        Gauge gauge = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[]{"key1:value1", "key2:value2"});
        Assert.assertNotNull((Object)gauge);
        Assert.assertEquals((Object)id, (Object)gauge.getId());
        Assert.assertEquals((double)original, (double)gauge.value(), (double)0.0);
    }

    @Test
    public void testInitBadTwoMeasurements() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_TWO_MEASUREMENTS);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testInitBadWrongStatistic() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_INVALID_WRONG_STATISTIC);
        TestUtils.assertThrows(IllegalArgumentException.class, () -> GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]));
    }

    @Test
    public void testGetUpdaterGauge() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        JsonObject expected = TestUtils.readJsonFromResources(FOLDER, JSON_UPDATER);
        Gauge gauge = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]);
        ((GaugeRepresentation)gauge).setValue(3.2);
        JsonObject updater = ((GaugeRepresentation)gauge).getUpdater();
        Assert.assertEquals((Object)expected, (Object)updater);
    }

    @Test
    public void testMeasure() throws IOException {
        JsonObject obj = TestUtils.readJsonFromResources(FOLDER, JSON_VALID);
        Gauge gauge = GaugeRepresentation.parseGauge((JsonObject)obj, (String[])new String[0]);
        List measurements = (List)gauge.measure();
        Assert.assertEquals((long)1L, (long)measurements.size());
        Assert.assertEquals((Object)Statistic.VALUE, (Object)((Measurement)measurements.get(0)).getStatistic());
        Assert.assertEquals((double)gauge.value(), (double)((Measurement)measurements.get(0)).getValue(), (double)0.0);
    }

    @Test
    public void testNameInitOk() {
        String name = "name";
        ArrayList tagList = new ArrayList();
        Meter.Id id = MetricsFactory.buildId((String)name, tagList, null, null, (Meter.Type)Meter.Type.GAUGE);
        Gauge gauge = GaugeRepresentation.createNewGauge((String)name);
        Assert.assertNotNull((Object)gauge);
        Assert.assertEquals((Object)id, (Object)gauge.getId());
        Assert.assertEquals((double)0.0, (double)gauge.value(), (double)0.0);
        List measurements = (List)gauge.measure();
        Assert.assertEquals((long)1L, (long)measurements.size());
        Assert.assertEquals((Object)Statistic.VALUE, (Object)((Measurement)measurements.get(0)).getStatistic());
        Assert.assertEquals((double)gauge.value(), (double)((Measurement)measurements.get(0)).getValue(), (double)0.0);
    }
}

