/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.Starter;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;

public class ServiceMapper {
    public static final String NAME_SUBMODEL = "service";
    public static final String NAME_PROP_ID = "id";
    public static final String NAME_PROP_NAME = "name";
    public static final String NAME_PROP_STATE = "state";
    public static final String NAME_PROP_DEPLOYABLE = "deployable";
    public static final String NAME_PROP_TOPLEVEL = "topLevel";
    public static final String NAME_PROP_KIND = "kind";
    public static final String NAME_PROP_VERSION = "version";
    public static final String NAME_PROP_DESCRIPTION = "description";
    public static final String NAME_OP_ACTIVATE = "activate";
    public static final String NAME_OP_PASSIVATE = "passivate";
    public static final String NAME_OP_MIGRATE = "migrate";
    public static final String NAME_OP_UPDATE = "update";
    public static final String NAME_OP_SWITCH = "switchTo";
    public static final String NAME_OP_RECONF = "reconfigure";
    public static final String NAME_OP_SET_STATE = "setState";
    public static final String NAME_OP_GET_STATE = "getState";
    public static final String[] PROP_READONLY = new String[]{"id", "name", "deployable", "topLevel", "kind", "version", "description", "state"};
    public static final String[] PROP_WRITEONLY = new String[0];
    public static final String[] PROP_READWRITE = new String[0];
    public static final String[] OPERATIONS = new String[]{"activate", "passivate", "migrate", "update", "switchTo", "reconfigure", "setState", "getState"};
    private ProtocolServerBuilder builder;

    public ServiceMapper(ProtocolServerBuilder builder) {
        this.builder = builder;
    }

    public void mapService(Service service) {
        try {
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_ID), () -> service.getId(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_DESCRIPTION), () -> service.getDescription(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_VERSION), () -> service.getVersion().toString(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_KIND), () -> service.getKind().toString(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_STATE), () -> service.getState().toString(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_NAME), () -> service.getName(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_DEPLOYABLE), () -> service.isDeployable(), null);
            this.builder.defineProperty(ServiceMapper.getQName(service, NAME_PROP_TOPLEVEL), () -> service.isTopLevel(), null);
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_ACTIVATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                service.activate();
                return null;
            }));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_PASSIVATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                service.passivate();
                return null;
            }));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_MIGRATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                service.migrate(AasUtils.readString((Object[])p));
                return null;
            }));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_RECONF), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                Map values = AasUtils.readMap((Object[])p, (int)0, null);
                Transport.sendTraceRecord((TraceRecord)new TraceRecord(service.getId(), NAME_OP_RECONF, (Object)values));
                service.reconfigure(values);
                return null;
            }));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_GET_STATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> service.getState().toString()));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_SET_STATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                ServiceState state = ServiceState.valueOf(AasUtils.readString((Object[])p, (int)0, (String)""));
                service.setState(state);
                LoggerFactory.getLogger(ServiceMapper.class).info("Setting state " + String.valueOf((Object)state) + " on " + service.getId() + " -> " + String.valueOf((Object)service.getState()));
                return null;
            }));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_SWITCH), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                service.switchTo(AasUtils.readString((Object[])p));
                return null;
            }));
            this.builder.defineOperation(ServiceMapper.getQName(service, NAME_OP_UPDATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
                service.update(AasUtils.readUri((Object[])p, (int)0, (URI)AasUtils.EMPTY_URI));
                return null;
            }));
        }
        catch (IllegalArgumentException e) {
            LoggerFactory.getLogger(ServiceMapper.class).error("Cannot map/register service: " + e.getMessage());
        }
    }

    public static String getQName(Service service, String elementName) {
        return ServiceMapper.getQName(Starter.getServiceId(service), elementName);
    }

    public static String getQName(String serviceId, String elementName) {
        return "service_" + serviceId + "_" + elementName;
    }

    public static String unqualify(String name) {
        int pos = name.lastIndexOf("_");
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }
}

