/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.connectors.ConnectorPluginDescriptor;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceDescriptor;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.PluginInstanceDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import de.iip_ecosphere.platform.support.setup.PluginsSetup;
import java.io.File;

public interface ServicePluginDescriptor<S extends Service>
extends PluginInstanceDescriptor<ServiceDescriptor<S>> {
    public static final String PLUGIN_ID_PREFIX = "service-";
    public static final String PLUGIN_TEST_ID_PREFIX = "service-test-";

    public static PluginManager.PluginFilter getServicePluginFilter() {
        return new PluginManager.PluginFilter(){

            public boolean accept(PluginManager.PluginInfo info) {
                return !info.getName().startsWith(ServicePluginDescriptor.PLUGIN_ID_PREFIX);
            }
        };
    }

    public static PluginManager.PluginFilter getConnectorAndServicePluginFilter() {
        return new PluginManager.ConjunctivePluginFilter(new PluginManager.PluginFilter[]{ServicePluginDescriptor.getServicePluginFilter(), ConnectorPluginDescriptor.getConnectorPluginFilter()});
    }

    public static void loadPlatformPlugins(PluginsSetup setup) {
        ServicePluginDescriptor.loadPlatformPlugins(setup.getPluginsFolder());
    }

    public static void loadPlatformPlugins(String pluginsFolder) {
        File f = new File(pluginsFolder);
        if (f.isDirectory()) {
            LoggerFactory.getLogger(ServicePluginDescriptor.class).info("Loading plugins from {}", (Object)f);
            PluginManager.loadAllFrom((File)f, (PluginManager.PluginFilter)ServicePluginDescriptor.getConnectorAndServicePluginFilter(), (PluginSetupDescriptor[])new PluginSetupDescriptor[0]);
        }
    }
}

