/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.junit.Test;
import test.de.iip_ecosphere.platform.services.environment.AasCreator;
import test.de.iip_ecosphere.platform.services.environment.AbstractEnvironmentTest;
import test.de.iip_ecosphere.platform.services.environment.MyService;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class AasTest
extends TestWithQpid {
    @Test
    public void testAas() throws IOException, ExecutionException {
        ServerAddress vabServer = new ServerAddress(Schema.HTTP);
        ServerAddress aasServer = new ServerAddress(Schema.HTTP);
        Endpoint aasServerRegistry = new Endpoint(Schema.HTTP, "registry");
        BasicSetupSpec spec = new BasicSetupSpec(aasServerRegistry, aasServer);
        spec.setAssetServerAddress(vabServer);
        MyService service = new MyService();
        AasCreator.AasResult res = new AasCreator.AasResult();
        Aas aas = AasCreator.createAas((SetupSpec)spec, (Service)service, res);
        ProtocolServerBuilder pBuilder = AasFactory.getInstance().createProtocolServerBuilder((SetupSpec)spec);
        ServiceMapper mapper = new ServiceMapper(pBuilder);
        mapper.mapService((Service)service);
        Server server = (Server)pBuilder.build();
        server.start();
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe((SetupSpec)spec).forRegistry().deploy(aas).createServer(new String[0]).start();
        AbstractEnvironmentTest.testAas((SetupSpec)spec, (Service)service);
        AbstractEnvironmentTest.testAasResult(res, (Service)service);
        httpServer.stop(true);
        server.stop(true);
    }
}

