/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractPythonProcessService;
import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.GenericMultiTypeServiceImpl;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class PythonAsyncProcessService
extends AbstractPythonProcessService {
    private Process proc;
    private PrintWriter serviceIn;
    private Map<String, String> reconfValues;

    public PythonAsyncProcessService(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    public PythonAsyncProcessService(YamlService yaml) {
        super(yaml);
    }

    @Override
    protected ServiceState start() throws ExecutionException {
        super.start();
        this.proc = this.createAndCustomizeProcess(null, null);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream()));
        this.serviceIn = new PrintWriter(writer);
        this.createScanInputThread(this.proc);
        if (null != this.reconfValues) {
            this.sendToService("*recfg", this.toJson(this.reconfValues));
            this.reconfValues = null;
        }
        return ServiceState.RUNNING;
    }

    protected void createScanInputThread(Process proc) {
        this.createScanInputThread(proc, (t, d) -> {
            GenericMultiTypeServiceImpl.OutTypeInfo<?> info = this.getOutTypeInfo(t);
            if (null != info) {
                this.handleResult(info.getType(), d, t);
            } else {
                PythonAsyncProcessService.getLogger().error("No output type translator registered for: {}", (Object)t);
            }
            return false;
        }).start();
    }

    @Override
    protected ServiceState stop() {
        if (null != this.serviceIn) {
            this.serviceIn.flush();
            this.serviceIn = null;
        }
        if (null != this.proc) {
            this.proc.destroyForcibly();
            while (null != this.proc && this.proc.isAlive()) {
                TimeUtils.sleep((int)200);
            }
            this.proc = null;
        }
        if (null != this.getHome() && this.isFileDeletionEnabled()) {
            try {
                FileUtils.forceDelete((File)this.getHome());
            }
            catch (IOException e) {
                PythonAsyncProcessService.getLogger().error("Cannot delete Python process home {}: {}", (Object)this.getHome(), (Object)e.getMessage());
            }
        }
        super.stop();
        return ServiceState.STOPPED;
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        ServiceState st;
        if (ServiceState.STOPPING == state) {
            this.sendToService("*setstate", state.name());
        }
        super.setState(state);
        if (state != ServiceState.STOPPING) {
            this.sendToService("*setstate", state.name());
        }
        if ((st = this.getState()) != state) {
            this.sendToService("*setstate", st.name());
        }
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
        this.sendToService("*migrate", resourceId);
    }

    @Override
    public void update(URI location) throws ExecutionException {
        this.sendToService("*update", location.toString());
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
        this.sendToService("*switch", targetId);
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        if (ServiceState.RUNNING == this.getState()) {
            this.sendToService("*recfg", this.toJson(values));
        } else {
            if (null == this.reconfValues) {
                this.reconfValues = new HashMap<String, String>();
            }
            this.reconfValues.putAll(values);
        }
        super.reconfigure(values);
    }

    @Override
    public void activate() throws ExecutionException {
        if (this.getState() == ServiceState.PASSIVATED) {
            this.sendToService("*activate", "");
        }
        super.activate();
    }

    @Override
    public void passivate() throws ExecutionException {
        if (this.getState() == ServiceState.RUNNING) {
            this.sendToService("*passivate", "");
        }
        super.passivate();
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(PythonAsyncProcessService.class);
    }

    protected void sendToService(String type, Object data) throws ExecutionException {
        PrintWriter si = this.serviceIn;
        if (null != si) {
            si.println(PythonAsyncProcessService.compose(type, data.toString()));
            si.flush();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <I> void process(String inType, I data) throws ExecutionException {
        GenericMultiTypeServiceImpl.InTypeInfo<?> info = this.getInTypeInfo(inType);
        if (null == info) throw new ExecutionException("No input type translator registered", null);
        TypeTranslator<?, String> inT = info.getInTranslator();
        if (null == inT) throw new ExecutionException("No input type translator registered", null);
        try {
            this.sendToService(inType, inT.to(data));
            return;
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot transfer data to service: " + e.getMessage(), e);
        }
    }

    @Override
    public <I, O> O processSync(String inTypeName, I data, String outTypeName) throws ExecutionException {
        this.process(inTypeName, data);
        GenericMultiTypeServiceImpl.OutTypeInfo<?> outInfo = this.getOutTypeInfo(outTypeName);
        DataIngestor<?> ingestor = outInfo.validateAndGetIngestor(outTypeName);
        return (O)ingestor.waitForResult();
    }
}

