/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.EnvironmentSetup;
import de.iip_ecosphere.platform.services.environment.ProcessSpec;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.testing.TestBroker;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import de.iip_ecosphere.platform.support.setup.InstalledDependenciesSetup;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;

public class Starter {
    public static final String PARAM_IIP_PROTOCOL = "iip.protocol";
    public static final String PARAM_IIP_PORT = "iip.port";
    public static final String PARAM_IIP_APP_ID = "iip.appId";
    public static final String PARAM_IIP_APP_PLUGINS = "iip.plugins";
    public static final String PARAM_IIP_TRANSPORT_GLOBAL = "iip.transport.global";
    public static final String PARAM_IIP_START_SERVER = "iip.start.server";
    public static final String PARAM_IIP_START_SERVER_ONLY = "iip.start.serverOnly";
    public static final String IIP_APP_PREFIX = "iip.app.";
    public static final String PARAM_IIP_TEST_TRANSPORT_PORT = "iip.test.transport.port";
    public static final String PARAM_IIP_TEST_AAS_PORT = "iip.test.aas.port";
    public static final String PARAM_IIP_TEST_SM_PORT = "iip.test.sm.port";
    public static final String PARAM_IIP_TEST_AASREG_PORT = "iip.test.aasRegistry.port";
    public static final String PARAM_IIP_TEST_SMREG_PORT = "iip.test.smRegistry.port";
    public static final String PARAM_IIP_TEST_SERVICE_AUTOSTART = "iip.test.service.autostart";
    public static final String ARG_AAS_NOTIFICATION = "iip.test.aas.notification";
    public static final String PROPERTY_JAVA8 = "iip.test.java8";
    public static final String IIP_TEST = "iip.test";
    public static final String IIP_TEST_PREFIX = "iip.test.";
    public static final String IIP_TEST_PLUGIN = "iip.test.plugin";
    private static ProtocolServerBuilder builder;
    private static Server cmdServer;
    private static Server appServer;
    private static Map<String, Integer> servicePorts;
    private static Map<String, Service> mappedServices;
    private static boolean serviceAutostart;
    private static boolean onServiceAutostartAttachShutdownHook;
    private static int transportPort;
    private static String transportHost;
    private static boolean transportGlobal;
    private static EnvironmentSetup setup;
    private static String appId;
    private static Map<String, Plugin> plugins;
    private static boolean oktoPluginsLoaded;
    private static Consumer<ProtocolServerBuilder> cmdServerConfigurer;
    protected static final Function<EnvironmentSetup, TransportSetup> DFLT_LOCAL_TRANSPORT_SETUP_SUPPLIER;
    private static Function<EnvironmentSetup, TransportSetup> localTransportSetupSupplier;

    protected static void registerPlugin(String name, Plugin plugin) {
        plugins.put(name.toLowerCase(), plugin);
    }

    protected static void registerDefaultPlugins(Plugin dflt) {
        Starter.registerPlugin("", dflt);
        Starter.registerPlugin("broker", new TestBroker());
        Starter.registerPlugin("help", new HelpPlugin());
    }

    public static boolean inTest() {
        return Boolean.valueOf(OsUtils.getPropertyOrEnv((String)IIP_TEST, (String)"false"));
    }

    public static void addAppEnvironment(List<String> args) {
        Starter.addAppEnvironment(args, new File(""));
    }

    public static void addAppEnvironment(List<String> args, File pluginParent) {
        for (Object k : System.getProperties().keySet()) {
            String key = k.toString();
            if (key == null || key.length() <= 0) continue;
            String val = System.getProperty(key);
            if (!key.startsWith(IIP_APP_PREFIX) && !key.startsWith(IIP_TEST_PREFIX) && !key.equals("iip.networkManager")) continue;
            args.add("-D" + key + "=" + val);
        }
        args.add("-Diip.plugins=" + pluginParent.getAbsolutePath());
        args.add("-Dokto.aasFactoryId=" + AasFactory.getPluginId());
    }

    public static ActiveAasBase.NotificationMode setAasNotificationMode(String[] args, ActiveAasBase.NotificationMode dflt) {
        ActiveAasBase.NotificationMode mode = dflt;
        String tmp = CmdLine.getArg((String[])args, (String)ARG_AAS_NOTIFICATION, (String)(null == mode ? "" : mode.name()));
        if (tmp.length() > 0) {
            try {
                mode = ActiveAasBase.NotificationMode.valueOf((String)tmp);
            }
            catch (IllegalArgumentException e) {
                Starter.getLogger().info("AAS notification mode {} unknown. Resorting to {}", (Object)tmp, (Object)mode);
            }
        }
        if (null != mode) {
            ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)mode);
        }
        return mode;
    }

    public static void considerInstalledDependencies() {
        String prop;
        if (!OsUtils.isJava1_8() && (prop = System.getProperty(PROPERTY_JAVA8, null)) != null) {
            File java8 = new File(prop);
            Starter.getLogger().info("Setting Java8 to: {}", (Object)java8);
            InstalledDependenciesSetup.getInstance().setLocation("JAVA8", java8);
        }
    }

    public static void transferArgsToEnvironment(String[] args) {
        for (String a : args) {
            String key;
            int pos;
            String tmp = null;
            if (a.startsWith("-D")) {
                tmp = a.substring(2);
            } else if (a.startsWith("--iip.app.")) {
                tmp = a.substring(2);
            }
            if (null == tmp || (pos = tmp.indexOf(61)) <= 0 || null != System.getProperty(key = tmp.substring(0, pos))) continue;
            String value = tmp.substring(pos + 1);
            System.setProperty(key, value);
        }
    }

    protected static boolean startServer(String[] args) {
        boolean handled = false;
        if (CmdLine.getBooleanArg((String[])args, (String)PARAM_IIP_START_SERVER_ONLY, (boolean)false)) {
            handled = true;
            String clsName = CmdLine.getArg((String[])args, (String)PARAM_IIP_START_SERVER, (String)"");
            if (clsName.length() > 0) {
                try {
                    Object o;
                    Class<?> cls = Class.forName(clsName);
                    try {
                        o = cls.getConstructor(String[].class).newInstance(new Object[]{args});
                    }
                    catch (NoSuchMethodException e) {
                        o = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    if (o instanceof Server) {
                        Starter.getLogger().info("Starting server {} ", (Object)clsName);
                        appServer = (Server)o;
                        appServer.start();
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            Server.stop((Server)appServer, (boolean)true);
                            appServer = null;
                        }));
                    }
                }
                catch (ClassNotFoundException e) {
                    Starter.getLogger().error("Starting server {}: Cannot find class {}", (Object)clsName, (Object)e.getMessage());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    Starter.getLogger().error("Starting server {}, cannot invoke constructor: {}", (Object)clsName, (Object)e.getMessage());
                }
            }
        }
        return handled;
    }

    public static String getAppId() {
        return appId;
    }

    public static String getServiceId(Service service) {
        return Starter.getServiceId(null == service ? "" : service.getId());
    }

    public static String getServiceId(String sId) {
        String appId = Starter.getAppId();
        if (null != appId && appId.length() > 0) {
            sId = (String)sId + "@" + appId;
        }
        return sId;
    }

    public static String getServiceCommandNetworkMgrKey(String serviceId) {
        return "admin_" + serviceId;
    }

    public static String getServiceProcessNetworkMgrKey(String serviceId) {
        return Starter.getServiceCommandNetworkMgrKey(serviceId) + "_process";
    }

    public static String composeArgument(String argName, Object value) {
        return "--" + argName + "=" + value.toString();
    }

    public static String getServicePortName(String serviceId) {
        return "iip.port." + Starter.normalizeServiceId(serviceId);
    }

    public static int getServicePort(String serviceId) {
        Integer port = servicePorts.get(Starter.normalizeServiceId(serviceId));
        return null == port ? -1 : port;
    }

    public static String normalizeServiceId(String serviceId) {
        return serviceId.replaceAll(" ", "");
    }

    public static void setServiceAutostart(boolean autostart) {
        serviceAutostart = autostart;
    }

    public static void setOnServiceAutostartAttachShutdownHook(boolean hook) {
        onServiceAutostartAttachShutdownHook = hook;
    }

    public static Service getMappedService(String serviceId) {
        return null == serviceId ? null : mappedServices.get(serviceId);
    }

    private static void configurePort(String[] args, String paramName, Consumer<Integer> consumer) {
        int tmpPort = CmdLine.getIntArg((String[])args, (String)paramName, (int)-1);
        if (tmpPort > 0) {
            consumer.accept(tmpPort);
        }
    }

    public static void parse(String ... args) {
        Starter.transferArgsToEnvironment(args);
        Starter.considerInstalledDependencies();
        AasFactory factory = AasFactory.getInstance();
        int port = CmdLine.getIntArg((String[])args, (String)PARAM_IIP_PORT, (int)-1);
        if (port < 0) {
            port = NetUtils.getEphemeralPort();
        }
        transportGlobal = CmdLine.getBooleanArg((String[])args, (String)PARAM_IIP_TRANSPORT_GLOBAL, (boolean)Boolean.valueOf(System.getProperty(PARAM_IIP_TRANSPORT_GLOBAL, "false")));
        transportHost = CmdLine.getArg((String[])args, (String)"transport.host", (String)transportHost);
        if ((transportPort = CmdLine.getIntArg((String[])args, (String)PARAM_IIP_TEST_TRANSPORT_PORT, (int)CmdLine.getIntArg((String[])args, (String)"transport.port", (int)transportPort))) > 0 || transportHost != null) {
            Starter.getSetup();
        }
        Starter.configurePort(args, PARAM_IIP_TEST_AAS_PORT, p -> {
            AasPartRegistry.getSetup().getServer().setPort(p.intValue());
            Starter.getLogger().info("Configuring AAS repository port to {}", p);
        });
        Starter.configurePort(args, PARAM_IIP_TEST_SM_PORT, p -> {
            AasPartRegistry.getSetup().getSubmodelServer().setPort(p.intValue());
            Starter.getLogger().info("Configuring SM repository port to {}", p);
        });
        Starter.configurePort(args, PARAM_IIP_TEST_AASREG_PORT, p -> {
            AasPartRegistry.getSetup().getRegistry().setPort(p.intValue());
            Starter.getLogger().info("Configuring AAS registry port to {}", p);
        });
        Starter.configurePort(args, PARAM_IIP_TEST_SMREG_PORT, p -> {
            AasPartRegistry.getSetup().getSubmodelRegistry().setPort(p.intValue());
            Starter.getLogger().info("Configuring SM registry port to {}", p);
        });
        appId = CmdLine.getArg((String[])args, (String)PARAM_IIP_APP_ID, (String)"");
        Starter.setAasNotificationMode(args, null);
        serviceAutostart = CmdLine.getBooleanArg((String[])args, (String)PARAM_IIP_TEST_SERVICE_AUTOSTART, (boolean)serviceAutostart);
        String protocol = CmdLine.getArg((String[])args, (String)PARAM_IIP_PROTOCOL, (String)"");
        boolean found = false;
        for (String p2 : factory.getProtocols()) {
            if (!p2.equals(protocol)) continue;
            found = false;
        }
        if (!found) {
            protocol = "";
        }
        for (String a : args) {
            int valPos;
            if (!a.startsWith("--iip.port.") || (valPos = a.indexOf("=")) <= 0) continue;
            String prefix = a.substring(0, valPos);
            int idPos = prefix.lastIndexOf(".");
            try {
                String serviceId = prefix.substring(idPos + 1);
                int p3 = Integer.parseInt(a.substring(valPos + 1));
                servicePorts.put(serviceId, p3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Starter.getLogger().info("Configuring service command server for protocol '" + protocol + "' (empty means default) and port " + port);
        builder = factory.createProtocolServerBuilder((SetupSpec)new BasicSetupSpec(protocol, port));
    }

    protected static void setCmdServerConfigurer(Consumer<ProtocolServerBuilder> configurer) {
        cmdServerConfigurer = configurer;
    }

    public static void start() {
        if (null != builder) {
            Starter.getLogger().info("Starting service command server");
            if (null != cmdServerConfigurer) {
                cmdServerConfigurer.accept(builder);
            }
            cmdServer = (Server)builder.build();
            cmdServer.start();
        } else {
            Starter.getLogger().error("Cannot start service command server as no builder is set.");
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(Starter.class);
    }

    public static ProtocolServerBuilder getProtocolBuilder() {
        return builder;
    }

    public static ServiceMapper getServiceMapper() {
        return new ServiceMapper(builder);
    }

    public static void mapService(ServiceMapper mapper, Service service, boolean enableAutostart) {
        if (null != service && service.getId() != null) {
            mappedServices.put(service.getId(), service);
            if (null != mapper && null != Starter.getProtocolBuilder()) {
                mapper.mapService(service);
            }
            if (serviceAutostart && enableAutostart && service.isTopLevel()) {
                try {
                    Starter.getLogger().info("Service autostart: '{}' '{}'", (Object)service.getId(), (Object)service.getClass().getName());
                    service.setState(ServiceState.STARTING);
                    if (onServiceAutostartAttachShutdownHook) {
                        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                            try {
                                System.out.println("Service autostop: " + service.getId());
                                service.setState(ServiceState.STOPPING);
                            }
                            catch (ExecutionException e) {
                                Starter.getLogger().error("Service autostop '{}': {}", (Object)service.getId(), (Object)e.getMessage());
                            }
                        }));
                    }
                }
                catch (ExecutionException e) {
                    Starter.getLogger().error("Service autostart '{}': {}", (Object)service.getId(), (Object)e.getMessage());
                }
            }
        } else if (null == setup || setup.getNotifyServiceNull()) {
            Throwable t = new Throwable("NO EXCEPTION/DEBUGGING: Service null or Service id null");
            t.printStackTrace(System.out);
        }
    }

    public static File extractProcessArtifacts(String sId, ProcessSpec pSpec, File artFile, File processBaseDir) throws IOException {
        File processDir = pSpec.getHomePath();
        if (null == processDir) {
            processDir = new File(processBaseDir, Starter.normalizeServiceId(sId) + "-" + System.currentTimeMillis());
        }
        if (!pSpec.isStarted()) {
            FileUtils.deleteQuietly((File)processDir);
        }
        processDir.mkdirs();
        for (String artPath : pSpec.getArtifacts()) {
            while (artPath.startsWith("/")) {
                artPath = artPath.substring(1);
            }
            InputStream artifact = Starter.findArtifact(artFile, artPath);
            if (null == artifact && null != (artifact = ResourceLoader.getResourceAsStream(Starter.class, (String)artPath, (ResourceResolver[])new ResourceResolver[0]))) {
                Starter.getLogger().info("Found " + artPath + " on classpath " + artifact.getClass().getSimpleName());
            }
            if (null == artifact) {
                throw new IOException("Cannot find artifact '" + artPath + "' in actual service JAR");
            }
            ZipUtils.extractZip((InputStream)artifact, (Path)processDir.toPath());
            Starter.getLogger().info("Extracted process artifact " + artPath + " to " + String.valueOf(processDir));
            FileUtils.closeQuietly((Closeable)artifact);
        }
        return processDir;
    }

    public static InputStream findArtifact(File artFile, String artPath) {
        InputStream artifact = null;
        try {
            artifact = ZipUtils.findFile((File)artFile, (String)("BOOT-INF/classes/" + artPath));
            if (null == artifact) {
                artifact = ZipUtils.findFile((File)artFile, (String)("BOOT-INF/classes-app/" + artPath));
            }
            if (null == artifact) {
                artifact = ZipUtils.findFile((File)artFile, (String)artPath);
                if (null != artifact) {
                    Starter.getLogger().info("Found " + artPath + " in " + String.valueOf(artFile) + " " + artifact.getClass().getSimpleName());
                }
            } else {
                Starter.getLogger().info("Found " + artPath + " in BOOT-INF/classes/" + artPath + " " + artifact.getClass().getSimpleName());
            }
        }
        catch (IOException e) {
            Starter.getLogger().info("Cannot open " + String.valueOf(artFile) + ": " + e.getMessage());
        }
        return artifact;
    }

    public static void mapService(Service service, boolean enableAutostart) {
        Starter.mapService(Starter.getServiceMapper(), service, enableAutostart);
    }

    public static void mapService(Service service) {
        Starter.mapService(service, true);
    }

    public static void shutdown() {
        Server.stop((Server)cmdServer, (boolean)false);
        Server.stop((Server)appServer, (boolean)true);
    }

    public static EnvironmentSetup getSetup() {
        if (null == setup) {
            try {
                Starter.getLogger().info("Loading setup");
                setup = (EnvironmentSetup)((Object)EnvironmentSetup.readFromYaml(EnvironmentSetup.class, (InputStream)Starter.getApplicationSetupAsStream()));
                if (transportPort > 0) {
                    setup.getTransport().setPort(transportPort);
                }
                if (transportHost != null) {
                    setup.getTransport().setHost(transportHost);
                }
                Transport.setTransportSetup(() -> setup.getTransport());
                Transport.createConnector();
                TransportSetup globalSetup = setup.getTransport();
                Starter.getLogger().info("Global transport {}:{}", (Object)globalSetup.getHost(), (Object)globalSetup.getPort());
                if (!transportGlobal && Starter.enablesLocalTransport(globalSetup)) {
                    TransportSetup localSetup;
                    TransportSetup lSetup = localTransportSetupSupplier.apply(setup);
                    if (null == lSetup && localTransportSetupSupplier != DFLT_LOCAL_TRANSPORT_SETUP_SUPPLIER) {
                        lSetup = DFLT_LOCAL_TRANSPORT_SETUP_SUPPLIER.apply(setup);
                    }
                    if (null != (localSetup = lSetup)) {
                        Starter.getLogger().info("Local transport {}:{}", (Object)localSetup.getHost(), (Object)localSetup.getPort());
                        Transport.setLocalSetup(() -> localSetup);
                    }
                } else {
                    Starter.getLogger().info("Local transport: use global as it is local");
                }
            }
            catch (IOException e) {
                setup = new EnvironmentSetup();
                Starter.getLogger().warn("Cannot read application.yml. Aas/Transport setup invalid");
            }
        }
        return setup;
    }

    protected static final boolean enablesLocalTransport(TransportSetup globalSetup) {
        boolean enable = false;
        String globalHost = globalSetup.getHost();
        if (!"localhost".equals(globalHost) && !"127.0.0.1".equals(globalHost)) {
            enable = !NetUtils.isOwnAddress((String)globalHost) || NetUtils.isInContainer();
        }
        return enable;
    }

    public static InputStream getApplicationSetupAsStream() {
        return ResourceLoader.getResourceAsStream((String)"application.yml", (ResourceResolver[])new ResourceResolver[0]);
    }

    protected static void setLocalTransportSetupSupplier(Function<EnvironmentSetup, TransportSetup> supplier) {
        if (null != supplier) {
            localTransportSetupSupplier = supplier;
        }
    }

    protected static void runPlugin(String[] args) {
        String test = CmdLine.getArg((String[])args, (String)IIP_TEST_PLUGIN, (String)"").toLowerCase();
        Plugin plugin = plugins.get(test);
        if (null == plugin) {
            System.out.println("No start plugin for '" + String.valueOf(plugin) + "' known. Stopping.");
        } else {
            plugin.run(args);
        }
    }

    public static void loadOktoPlugins() {
        if (!oktoPluginsLoaded) {
            oktoPluginsLoaded = true;
            File pluginParent = new File(System.getProperty(PARAM_IIP_APP_PLUGINS, "target"));
            File plugins = new File(pluginParent, "plugins");
            if (!plugins.isDirectory() && !(plugins = new File(pluginParent, "oktoPlugins")).isDirectory()) {
                plugins = pluginParent;
            }
            LoggerFactory.getLogger(Starter.class).info("Using {} as oktoflow plugin directory", (Object)plugins);
            if (plugins.isDirectory()) {
                LoggerFactory.getLogger(Starter.class).info("Trying to load oktoflow plugins from {}", (Object)plugins);
                PluginManager.PluginFilter filter = info -> {
                    String name = info.getName();
                    boolean ok = true;
                    ok &= !name.startsWith("support.log-");
                    ok &= !name.startsWith("support.metrics-");
                    ok &= !name.startsWith("services.");
                    ok &= !name.startsWith("ecsRuntime.");
                    ok &= !name.startsWith("monitoring.");
                    ok &= !name.startsWith("configuration.");
                    return ok &= !name.startsWith("deviceMgt.");
                };
                PluginManager.loadAllFrom((File)plugins, (PluginManager.PluginFilter)filter, (PluginSetupDescriptor[])new PluginSetupDescriptor[0]);
            }
        }
    }

    public static void main(String[] args) {
        Starter.registerDefaultPlugins(a -> Starter.start());
        Starter.parse(args);
        Starter.loadOktoPlugins();
        if (!Starter.startServer(args)) {
            Starter.getSetup();
            Starter.runPlugin(args);
        }
    }

    static {
        servicePorts = new HashMap<String, Integer>();
        mappedServices = new HashMap<String, Service>();
        serviceAutostart = false;
        onServiceAutostartAttachShutdownHook = true;
        transportPort = -1;
        transportHost = null;
        transportGlobal = false;
        appId = "";
        plugins = new HashMap<String, Plugin>();
        oktoPluginsLoaded = false;
        cmdServerConfigurer = null;
        DFLT_LOCAL_TRANSPORT_SETUP_SUPPLIER = setup -> {
            TransportSetup localSetup = null;
            TransportSetup globalSetup = setup.getTransport();
            String globalHost = globalSetup.getHost();
            if (!("localhost".equals(globalHost) || "127.0.0.1".equals(globalHost) || NetUtils.isOwnAddress((String)globalHost))) {
                localSetup = setup.getTransport().copy();
                localSetup.setHost("localhost");
            }
            return localSetup;
        };
        localTransportSetupSupplier = DFLT_LOCAL_TRANSPORT_SETUP_SUPPLIER;
    }

    public static interface Plugin {
        public void run(String[] var1);

        default public String getHelp(String indent) {
            return "runs default starter functionality";
        }
    }

    private static class HelpPlugin
    implements Plugin {
        private HelpPlugin() {
        }

        @Override
        public void run(String[] args) {
            List names = CollectionUtils.toList(plugins.keySet().iterator());
            Collections.sort(names);
            for (String n : names) {
                System.out.println("- " + n + ": " + plugins.get(n).getHelp("  "));
            }
        }

        @Override
        public String getHelp(String indent) {
            return "prints this help";
        }
    }
}

