/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.services;

import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactory;
import java.io.IOException;
import java.net.URI;

public abstract class WsAdapter {
    private WebsocketFactory.WebSocket socket;
    private Logger logger;
    private String lastError;

    public WsAdapter(URI serverUri, final Logger logger) {
        this.logger = logger;
        try {
            this.socket = WebsocketFactory.getInstance().createSocket(serverUri);
            this.socket.setReceptionHander(m -> this.onMessage((String)m));
            this.socket.setStatusListener(new WebsocketFactory.StatusListener(){

                public void onConnect() {
                }

                public void onClose(String reason, boolean remote) {
                    if (remote) {
                        logger.info("Connection closed by remote peer, reason: {}", (Object)reason);
                    }
                }

                public void onError(String msg) {
                    if (null == WsAdapter.this.lastError || !WsAdapter.this.lastError.equals(msg)) {
                        WsAdapter.this.lastError = msg;
                        logger.error("While running: {}", (Object)msg);
                    }
                }
            });
        }
        catch (IOException e) {
            logger.error("While creating socket: {}", (Object)e.getMessage());
        }
    }

    protected abstract void onMessage(String var1);

    public void send(String text) throws IOException {
        if (null != this.socket) {
            this.socket.send(text);
        }
    }

    public void close() {
        if (null != this.socket) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.logger.error("While closing socket: {}", (Object)e.getMessage());
            }
        }
    }

    public boolean connectBlocking() {
        if (null != this.socket) {
            try {
                return this.socket.connectBlocking();
            }
            catch (IOException e) {
                this.logger.error("While connecting socket: {}", (Object)e.getMessage());
                return false;
            }
        }
        return false;
    }

    public URI getURI() {
        return null == this.socket ? null : this.socket.getURI();
    }

    public void connect() {
        if (null != this.socket) {
            try {
                this.socket.connect();
            }
            catch (IOException e) {
                this.logger.error("While connecting socket: {}", (Object)e.getMessage());
            }
        }
    }

    public boolean isOpen() {
        return null == this.socket ? false : this.socket.isOpen();
    }

    public boolean isClosed() {
        return null == this.socket ? true : this.socket.isClosed();
    }

    public void closeBlocking() throws IOException {
        this.socket.closeBocking();
    }
}

