/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.TransportLogger;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.transport.TestWithQpid;

public class TransportLoggerTests
extends TestWithQpid {
    @Test
    public void testLogger() {
        File out = new File(FileUtils.getTempDirectory(), "iip-logger.txt");
        FileUtils.deleteQuietly((File)out);
        String outFile = "--outFile=" + out.getAbsolutePath();
        String setupFile = "--setupFile=./src/test/resources/envSetup.yml";
        ServerAddress broker = new ServerAddress(Schema.IGNORE);
        this.qpid = TestWithQpid.fromPlugin((ServerAddress)broker);
        this.qpid.start();
        AtomicInteger loopCount = new AtomicInteger(0);
        AtomicInteger receivedCount = new AtomicInteger(0);
        TransportLogger.setLoopEndSupplier(() -> {
            if (loopCount.get() == 1) {
                TransportLoggerTests.sendTestData();
            }
            if (loopCount.get() < 10) {
                loopCount.incrementAndGet();
                return true;
            }
            loopCount.set(0);
            return false;
        });
        TransportLogger.setSetupCustomizer(s -> s.getTransport().setPort(broker.getPort()));
        TransportLogger.setReceptionConsumer((c, t) -> receivedCount.incrementAndGet());
        TransportLogger.setShutdownRunnable(() -> {});
        TransportLogger.main((String[])new String[]{"--setupFile=./src/test/resources/envSetup.yml"});
        Assert.assertEquals((long)0L, (long)receivedCount.getAndSet(0));
        Assert.assertFalse((boolean)out.exists());
        TransportLogger.main((String[])new String[]{"--setupFile=./src/test/resources/envSetup.yml", outFile, "--traces=true"});
        Assert.assertEquals((long)1L, (long)receivedCount.getAndSet(0));
        Assert.assertTrue((boolean)out.exists());
        Assert.assertTrue((out.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteQuietly((File)out);
        TransportLogger.main((String[])new String[]{"--setupFile=./src/test/resources/envSetup.yml", outFile, "--traces=true", "--metrics=true", "--status=true"});
        Assert.assertEquals((long)3L, (long)receivedCount.getAndSet(0));
        Assert.assertTrue((boolean)out.exists());
        Assert.assertTrue((out.length() > 0L ? 1 : 0) != 0);
        FileUtils.deleteQuietly((File)out);
        TransportLogger.shutdown();
        this.qpid.stop(true);
    }

    private static void sendTestData() {
        Transport.sendContainerStatus((ActionType)ActionTypes.ADDED, (String)"myContainer", (String[])new String[0]);
        Transport.sendTraceRecord((TraceRecord)new TraceRecord("src", "act", (Object)""));
        Transport.send(s -> s.asyncSend("EcsMetrics", (Object)"{}"), (String)"metrics");
    }
}

