/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.EnvironmentSetup;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.IipVersion;
import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class TransportLogger {
    private static EnvironmentSetup setup;
    private static TransportConnector conn;
    private static Map<String, TransportHandler<?>> handlers;
    private static Consumer<EnvironmentSetup> setupCustomizer;
    private static BiConsumer<Category, String> receptionConsumer;
    private static Supplier<Boolean> loopEndSupplier;
    private static Runnable shutdownRunnable;
    private static PrintStream fileOut;

    protected static void addHandler(String arg, TransportHandler<?> handler) {
        if (null != arg && null != handler) {
            handlers.put(arg, handler);
        }
    }

    protected static <T> void addHandler(String arg, String stream, Class<T> cls, Consumer<T> cons) {
        TransportLogger.addHandler(arg, new TransportHandler<T>(stream, cls, cons));
    }

    protected static String toString(Object obj) {
        return StringUtils.toStringShortStyle((Object)obj);
    }

    public static void setSetupCustomizer(Consumer<EnvironmentSetup> customizer) {
        if (null != customizer) {
            setupCustomizer = customizer;
        }
    }

    public static void setReceptionConsumer(BiConsumer<Category, String> consumer) {
        receptionConsumer = consumer;
    }

    public static void setShutdownRunnable(Runnable runnable) {
        if (null != runnable) {
            shutdownRunnable = runnable;
        }
    }

    public static void setLoopEndSupplier(Supplier<Boolean> supplier) {
        if (null != supplier) {
            loopEndSupplier = supplier;
        }
    }

    private static void log(Category category, String text) {
        System.out.println(String.valueOf((Object)category) + " " + text);
        if (null != fileOut) {
            fileOut.println(String.valueOf((Object)category) + " " + text);
        }
        if (null != receptionConsumer) {
            receptionConsumer.accept(category, text);
        }
    }

    public static void main(String[] args) {
        TransportLogger.addHandler("traces", "Trace", TraceRecord.class, r -> TransportLogger.log(Category.TRACE, TransportLogger.toString(r)));
        TransportLogger.addHandler("status", "ComponentStatus", StatusMessage.class, s -> TransportLogger.log(Category.STATUS, TransportLogger.toString(s)));
        TransportLogger.addHandler("metrics", "EcsMetrics", String.class, m -> TransportLogger.log(Category.METRICS, m));
        try {
            System.out.println("IIP-Ecosphere transport message logger (" + IipVersion.getInstance().getVersion() + ")");
            System.out.println(" --traces=true enables reception/output of service traces (if enabled on services)");
            System.out.println(" --status=true enables reception/output of platform status messages");
            System.out.println(" --metrics=true enables reception/output of platform monitoring messages");
            System.out.println(" --setupFile=<resource/file> defines setup file, also -DsetupFile=<file> (default application.yml)");
            System.out.println(" --outFile=<file> writes log also to file (default none)");
            String file = CmdLine.getArg((String[])args, (String)"setupFile", (String)System.getProperty("setupFile", "application.yml"));
            System.out.println("Using setup file: " + file);
            InputStream in = ResourceLoader.getResourceAsStream((String)file, (ResourceResolver[])new ResourceResolver[]{new FolderResourceResolver(new File("."))});
            setup = (EnvironmentSetup)((Object)EnvironmentSetup.readFromYaml(EnvironmentSetup.class, (InputStream)in));
            setupCustomizer.accept(setup);
            Transport.setTransportSetup(() -> setup.getTransport());
            file = CmdLine.getArg((String[])args, (String)"outFile", null);
            if (null != file) {
                try {
                    fileOut = new PrintStream(new FileOutputStream(file));
                }
                catch (IOException e) {
                    System.out.println("Cannot open output stream to '" + file + "'. Discarding output. Reason: " + e.getMessage());
                }
            }
            conn = Transport.createConnector();
            for (String string : handlers.keySet()) {
                if (!CmdLine.getBooleanArg((String[])args, (String)string, (boolean)false)) continue;
                System.out.println("Enabling handler for " + string);
                handlers.get(string).initialize();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(shutdownRunnable));
            System.out.println("Receiving transport messages until Ctrl-C");
            do {
                TimeUtils.sleep((int)500);
            } while (loopEndSupplier.get().booleanValue());
            for (TransportHandler transportHandler : handlers.values()) {
                transportHandler.detach();
            }
            handlers.clear();
            if (null != fileOut) {
                fileOut.flush();
                FileUtils.closeQuietly((Closeable)fileOut);
                fileOut = null;
            }
        }
        catch (IOException e) {
            System.out.println("Cannot read environment/transport setup. Started from within app?");
        }
    }

    public static void shutdown() {
        if (null != conn) {
            Transport.releaseConnector((boolean)false);
            conn = null;
        }
    }

    static {
        handlers = new HashMap();
        setupCustomizer = s -> {};
        receptionConsumer = (c, s) -> {};
        loopEndSupplier = () -> true;
        shutdownRunnable = () -> TransportLogger.shutdown();
        fileOut = null;
    }

    protected static class TransportHandler<T>
    implements ReceptionCallback<T> {
        private String stream;
        private Class<T> cls;
        private Consumer<T> cons;

        protected TransportHandler(String stream, Class<T> cls, Consumer<T> cons) {
            this.stream = stream;
            this.cls = cls;
            this.cons = cons;
        }

        public void initialize() throws IOException {
            conn.setReceptionCallback(this.stream, (ReceptionCallback)this);
        }

        public void detach() throws IOException {
            this.cons = null;
        }

        public void received(T data) {
            if (null != this.cons) {
                this.cons.accept(data);
            }
        }

        public Class<T> getType() {
            return this.cls;
        }
    }

    public static enum Category {
        TRACE,
        STATUS,
        METRICS;

    }
}

