/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.FamilyServiceStub;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class DefaultServiceImplTest {
    @Test
    public void testDefaultServiceImpl() throws ExecutionException {
        DefaultServiceImpl service = new DefaultServiceImpl("simpleStream-create", AbstractService.getResourceAsStream((ClassLoader)DefaultServiceImplTest.class.getClassLoader(), (String)"deployment.yml"));
        this.testOps((Service)service);
    }

    private void testOps(Service service) throws ExecutionException {
        Assert.assertNotNull((Object)service.getId());
        Assert.assertNotNull((Object)service.getDescription());
        Assert.assertNotNull((Object)service.getName());
        Assert.assertNotNull((Object)service.getKind());
        Assert.assertNull((Object)service.getParameterConfigurer("abc"));
        Assert.assertNotNull((Object)service.getState());
        Assert.assertNotNull((Object)service.getVersion());
        Assert.assertTrue((boolean)service.isTopLevel());
        Assert.assertTrue((boolean)service.isDeployable());
        service.setState(ServiceState.STARTING);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)service.getState());
        service.migrate("");
        service.passivate();
        service.activate();
        service.switchTo("");
        service.update(null);
    }

    @Test
    public void testFamilyServiceStub() throws ExecutionException {
        DefaultServiceImpl service = new DefaultServiceImpl("simpleStream-create", AbstractService.getResourceAsStream((ClassLoader)DefaultServiceImplTest.class.getClassLoader(), (String)"deployment.yml"));
        FamilyServiceStub family = new FamilyServiceStub("simpleStream-create", AbstractService.getResourceAsStream((ClassLoader)DefaultServiceImplTest.class.getClassLoader(), (String)"deployment.yml"));
        family.setActiveMemberSupplier(() -> service);
        this.testOps((Service)family);
        Assert.assertEquals((Object)ServiceState.RUNNING, (Object)service.getState());
    }
}

