/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractPythonProcessService;
import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class GenericMultiTypeServiceImpl {
    private Map<String, OutTypeInfo<?>> outTypeInfos = new HashMap();
    private Map<String, InTypeInfo<?>> inTypeInfos = new HashMap();
    private Map<String, String> inOutTypeRelations = new HashMap<String, String>();

    public <O> OutTypeInfo<O> obtainOutTypeInfo(Class<O> cls, String typeName) {
        OutTypeInfo<Object> info = this.outTypeInfos.get(typeName);
        if (null == info) {
            info = new OutTypeInfo<O>(cls);
            this.outTypeInfos.put(typeName, info);
        }
        return info;
    }

    public <I> InTypeInfo<I> obtainInTypeInfo(Class<I> cls, String typeName) {
        InTypeInfo<Object> info = this.inTypeInfos.get(typeName);
        if (null == info) {
            info = new InTypeInfo<I>(cls);
            this.inTypeInfos.put(typeName, info);
        }
        return info;
    }

    public InTypeInfo<?> getInTypeInfo(String inTypeName) {
        return this.inTypeInfos.get(inTypeName);
    }

    public OutTypeInfo<?> getOutTypeInfo(String outTypeName) {
        return this.outTypeInfos.get(outTypeName);
    }

    public <I> void registerInputTypeTranslator(Class<I> inCls, String inTypeName, TypeTranslator<I, String> inTrans) {
        InTypeInfo<I> info = this.obtainInTypeInfo(inCls, inTypeName);
        info.inTranslator = inTrans;
    }

    public void registerInOutRelation(String inTypeName, String outTypeName) {
        this.inOutTypeRelations.put(inTypeName, outTypeName);
    }

    public String getOutTypeName(String inTypeName) {
        return this.inOutTypeRelations.get(inTypeName);
    }

    public <O> void attachIngestor(Class<O> outCls, String outTypeName, DataIngestor<O> ingestor) {
        OutTypeInfo<O> info = this.obtainOutTypeInfo(outCls, outTypeName);
        info.ingestor = ingestor;
    }

    public <O> void registerOutputTypeTranslator(Class<O> outCls, String outTypeName, TypeTranslator<String, O> outTrans) {
        OutTypeInfo<O> info = this.obtainOutTypeInfo(outCls, outTypeName);
        info.outTranslator = outTrans;
    }

    public static class OutTypeInfo<T>
    extends AbstractTypeInfo<T> {
        private TypeTranslator<String, T> outTranslator;
        private DataIngestor<T> ingestor;

        protected OutTypeInfo(Class<T> type) {
            super(type);
        }

        public TypeTranslator<String, T> getOutTranslator() {
            return this.outTranslator;
        }

        protected DataIngestor<T> getIngestor() {
            return this.ingestor;
        }

        public DataIngestor<T> validateAndGetIngestor(String typeName) {
            if (null == this.ingestor) {
                LoggerFactory.getLogger(this.getClass()).info("No ingestor registered for: {}. Registering an internal synchronous ingestor.", (Object)typeName);
                this.ingestor = new AbstractPythonProcessService.SyncDataIngestor<T>();
            }
            return this.ingestor;
        }

        protected void validateAndIngest(String typeName, String data) throws IOException {
            this.ingestor.ingest(this.outTranslator.to((Object)data));
        }
    }

    public static class InTypeInfo<T>
    extends AbstractTypeInfo<T> {
        private TypeTranslator<T, String> inTranslator;

        protected InTypeInfo(Class<T> type) {
            super(type);
        }

        public TypeTranslator<T, String> getInTranslator() {
            return this.inTranslator;
        }
    }

    public static abstract class AbstractTypeInfo<T> {
        private Class<T> type;

        protected AbstractTypeInfo(Class<T> type) {
            this.type = type;
        }

        public Class<T> getType() {
            return this.type;
        }
    }
}

