/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.switching;

import de.iip_ecosphere.platform.services.environment.ServiceState;
import java.util.concurrent.ExecutionException;

public interface ServiceBase {
    public static final String APPLICATION_SEPARATOR = "@";
    public static final String DEFAULT_APPLICATION_INSTANCE_ID = "dflt";

    public String getId();

    public ServiceState getState();

    public void setState(ServiceState var1) throws ExecutionException;

    public static String getServiceId(String id) {
        int pos = id.indexOf(APPLICATION_SEPARATOR);
        String result = pos > 0 ? id.substring(0, pos) : id;
        return result;
    }

    public static String getApplicationId(String id) {
        int fPos = id.indexOf(APPLICATION_SEPARATOR);
        int lPos = id.lastIndexOf(APPLICATION_SEPARATOR);
        String result = fPos > 0 && lPos > 0 && fPos != lPos ? id.substring(fPos + 1, lPos) : (fPos > 0 ? id.substring(fPos + 1) : "");
        return result;
    }

    public static String getApplicationInstanceId(String id) {
        int fPos = id.indexOf(APPLICATION_SEPARATOR);
        int lPos = id.lastIndexOf(APPLICATION_SEPARATOR);
        String result = fPos > 0 && lPos > 0 && fPos != lPos ? id.substring(lPos + 1) : "";
        return result;
    }

    public static String validateApplicationInstanceId(String appInstanceId) {
        String result = appInstanceId;
        if (appInstanceId == null || appInstanceId.length() == 0) {
            result = DEFAULT_APPLICATION_INSTANCE_ID;
        }
        return result;
    }

    public static String composeId(String serviceId, String applicationId) {
        return ServiceBase.composeId(serviceId, applicationId, "");
    }

    public static String composeId(String serviceId, String applicationId, String applicationInstanceId) {
        Object result;
        if (null != applicationId && applicationId.length() > 0) {
            result = serviceId.replace(APPLICATION_SEPARATOR, "");
            result = (String)result + APPLICATION_SEPARATOR + applicationId.replace(APPLICATION_SEPARATOR, "");
            if (null != applicationInstanceId && applicationInstanceId.length() > 0) {
                result = (String)result + APPLICATION_SEPARATOR + applicationInstanceId.replace(APPLICATION_SEPARATOR, "");
            }
        } else {
            result = serviceId.replace(APPLICATION_SEPARATOR, "");
        }
        return result;
    }
}

