/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.oktoflow.platform.tools.lib.PythonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.Consumer;

public class ProcessSupport {
    public static final Consumer<ProcessBuilder> INHERIT_IO = p -> p.inheritIO();

    public static void callPython(ScriptOwner owner, String script, Consumer<String> cmdResult, String ... args) {
        if (!owner.isInitialized() && null == owner.getPythonFolder()) {
            owner.setPythonFolder(new File(owner.getTestFallbackPath()));
            if (!owner.getPythonFolder().exists()) {
                InputStream in = ResourceLoader.getResourceAsStream(ProcessSupport.class, (String)owner.getZipFileName(), (ResourceResolver[])new ResourceResolver[0]);
                if (null == in) {
                    LoggerFactory.getLogger(ProcessSupport.class).error("Cannot find python scripts, neither local nor in ZIP on classpath");
                } else {
                    File tmp = FileUtils.createTmpFolder((String)owner.getTmpFolderName());
                    try {
                        ZipUtils.extractZip((InputStream)in, (Path)tmp.toPath());
                        owner.setPythonFolder(tmp);
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(ProcessSupport.class).error("Cannot extract python scripts: {}", (Object)e.getMessage());
                    }
                }
            } else {
                owner.setInitialized(true);
            }
        }
        if (owner.getPythonFolder() != null) {
            ProcessSupport.callPythonWaitForAndKill(owner.getPythonFolder(), script, cmdResult, owner.getResultFile(), owner.getProcessCustomizer(), args);
        }
    }

    public static Process createPythonProcess(File dir, String script, Consumer<ProcessBuilder> procCustomizer, String ... args) throws IOException {
        String pythonPath = PythonUtils.getPythonExecutable().toString();
        LoggerFactory.getLogger(ProcessSupport.class).info("Using Python: {}", (Object)pythonPath);
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(pythonPath);
        tmp.add("-u");
        tmp.add(script);
        for (String a : args) {
            tmp.add(a);
        }
        LoggerFactory.getLogger(ProcessSupport.class).info("Cmd line: {} in {}", tmp, (Object)dir);
        ProcessBuilder processBuilder = new ProcessBuilder(tmp);
        processBuilder.directory(dir);
        if (null != procCustomizer) {
            procCustomizer.accept(processBuilder);
        }
        Process python = processBuilder.start();
        return python;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int waitForAndKill(Process proc, String script, Consumer<String> cmdResult, String resultFile) {
        int procResult = -1;
        AbstractProcessService.RunnableWithStop redirect = null;
        try {
            ByteArrayOutputStream res = null;
            if (null != cmdResult && null == resultFile) {
                res = new ByteArrayOutputStream();
                redirect = AbstractProcessService.redirectIO(proc.getInputStream(), new PrintStream(res));
            }
            procResult = proc.waitFor();
            AbstractProcessService.waitAndDestroy(proc, 200);
            if (null != res) {
                cmdResult.accept(res.toString());
            } else if (resultFile != null) {
                cmdResult.accept(FileUtils.readFileToString((File)new File(resultFile), (Charset)StandardCharsets.UTF_8));
            }
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(ProcessSupport.class).error("Waiting for script {} interrupted: {}", (Object)script, (Object)e.getMessage());
        }
        catch (IOException e) {
            LoggerFactory.getLogger(ProcessSupport.class).error("Reading for script {} results: {}", (Object)script, (Object)e.getMessage());
        }
        finally {
            if (null != redirect) {
                redirect.stop();
            }
        }
        return procResult;
    }

    public static int callPythonWaitForAndKill(File dir, String script, Consumer<String> cmdResult, String resultFile, Consumer<ProcessBuilder> cust, String ... args) {
        try {
            Consumer<ProcessBuilder> customizer = cust;
            if (null == cust && null == cmdResult) {
                customizer = pb -> pb.inheritIO();
            }
            return ProcessSupport.waitForAndKill(ProcessSupport.createPythonProcess(dir, script, customizer, args), script, cmdResult, resultFile);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(ProcessSupport.class).error("Cannot execute python script {}: {}", (Object)script, (Object)e.getMessage());
            return -1;
        }
    }

    public static class ScriptOwner {
        private boolean initialized = false;
        private File pythonFolder = null;
        private String tmpFolderName;
        private String testFallbackPath;
        private String zipFileName;
        private String resultFile;
        private Consumer<ProcessBuilder> processCustomizer;

        public ScriptOwner(String tmpFolderName, String testFallbackPath, String zipFileName) {
            this(tmpFolderName, testFallbackPath, zipFileName, null);
        }

        public ScriptOwner(String tmpFolderName, String testFallbackPath, String zipFileName, String resultFile) {
            this.tmpFolderName = tmpFolderName;
            this.testFallbackPath = testFallbackPath;
            this.zipFileName = zipFileName;
            this.resultFile = resultFile;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public File getPythonFolder() {
            return this.pythonFolder;
        }

        void setPythonFolder(File pythonFolder) {
            this.pythonFolder = pythonFolder;
        }

        public String getTmpFolderName() {
            return this.tmpFolderName;
        }

        public String getTestFallbackPath() {
            return this.testFallbackPath;
        }

        public String getZipFileName() {
            return this.zipFileName;
        }

        public String getResultFile() {
            return this.resultFile;
        }

        public ScriptOwner withProcessCustomizer(Consumer<ProcessBuilder> customizer) {
            this.processCustomizer = customizer;
            return this;
        }

        public Consumer<ProcessBuilder> getProcessCustomizer() {
            return this.processCustomizer;
        }
    }
}

