/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Invokable;
import de.iip_ecosphere.platform.support.function.IOSupplier;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.LogLevel;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class ServiceStub
implements Service {
    private Map<String, Invokable> getters = new HashMap<String, Invokable>();
    private Map<String, Invokable> setters = new HashMap<String, Invokable>();
    private Map<String, Invokable> operations = new HashMap<String, Invokable>();

    public ServiceStub(InvocablesCreator iCreator, String serviceId, String ... path) {
        this(iCreator, serviceId, (IOSupplier<Aas>)null, path);
    }

    public ServiceStub(InvocablesCreator iCreator, String serviceId, IOSupplier<Aas> aasSupplier, String ... path) {
        if (aasSupplier == null) {
            aasSupplier = () -> AasPartRegistry.retrieveIipAas();
        }
        iCreator = iCreator.executableCreator(aasSupplier, path, s -> ServiceMapper.unqualify(s));
        iCreator.setLogLevel(LogLevel.INFO);
        for (String n : ServiceMapper.PROP_READONLY) {
            this.registerProperty(n, iCreator.createGetter(ServiceMapper.getQName(serviceId, n)), InvocablesCreator.READ_ONLY);
        }
        for (String n : ServiceMapper.PROP_WRITEONLY) {
            this.registerProperty(n, InvocablesCreator.WRITE_ONLY, iCreator.createSetter(ServiceMapper.getQName(serviceId, n)));
        }
        for (String n : ServiceMapper.PROP_READWRITE) {
            this.registerProperty(n, iCreator.createGetter(ServiceMapper.getQName(serviceId, n)), iCreator.createSetter(ServiceMapper.getQName(serviceId, n)));
        }
        for (String n : ServiceMapper.OPERATIONS) {
            this.registerOperation(n, iCreator.createInvocable(ServiceMapper.getQName(serviceId, n)));
        }
    }

    private void registerProperty(String name, Invokable getter, Invokable setter) {
        this.getters.put(name, getter);
        this.setters.put(name, setter);
    }

    private void registerOperation(String name, Invokable operation) {
        this.operations.put(name, operation);
    }

    public Invokable getGetter(String name) {
        return this.getters.get(name);
    }

    public Invokable getSetter(String name) {
        return this.setters.get(name);
    }

    public Invokable getOperation(String name) {
        return this.operations.get(name);
    }

    private <T> T convertGetterResult(String getId, T dflt, Function<Object, T> conversion) {
        Object response = this.getters.get(getId).getGetter().get();
        T result = null == response ? dflt : conversion.apply(response);
        return result;
    }

    private String convertGetterResultToString(String getId) {
        return this.convertGetterResult(getId, "", r -> r.toString());
    }

    public static <T extends Enum<T>> T convertToEnumSafe(Object val, T dflt, Class<T> cls) {
        T result;
        try {
            result = Enum.valueOf(cls, val.toString());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            result = dflt;
        }
        return result;
    }

    private <T extends Enum<T>> T convertGetterResultToEnum(String getId, T dflt, Class<T> cls) {
        return (T)this.convertGetterResult(getId, dflt, r -> ServiceStub.convertToEnumSafe(r, dflt, cls));
    }

    @Override
    public String getId() {
        return this.convertGetterResultToString("id");
    }

    @Override
    public String getName() {
        return this.convertGetterResultToString("name");
    }

    @Override
    public Version getVersion() {
        return this.convertGetterResult("version", null, r -> new Version(r.toString()));
    }

    @Override
    public String getDescription() {
        return this.convertGetterResultToString("description");
    }

    @Override
    public ServiceState getState() {
        try {
            Object[] param = new Object[]{};
            return ServiceStub.convertToEnumSafe(JsonResultWrapper.fromJson((Function)this.operations.get("getState").getOperation(), (Object[])param), null, ServiceState.class);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    public boolean isDeployable() {
        return this.convertGetterResult("deployable", false, r -> Boolean.valueOf(r.toString()));
    }

    @Override
    public boolean isTopLevel() {
        return this.convertGetterResult("topLevel", false, r -> Boolean.valueOf(r.toString()));
    }

    @Override
    public ServiceKind getKind() {
        return this.convertGetterResultToEnum("kind", null, ServiceKind.class);
    }

    @Override
    public void setState(ServiceState state) throws ExecutionException {
        Object[] param = new Object[]{state.name()};
        JsonResultWrapper.fromJson((Function)this.operations.get("setState").getOperation(), (Object[])param);
    }

    @Override
    public void migrate(String resourceId) throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.operations.get("migrate").getOperation());
    }

    @Override
    public void update(URI location) throws ExecutionException {
        Object[] param = new Object[]{location.toString()};
        JsonResultWrapper.fromJson((Function)this.operations.get("update").getOperation(), (Object[])param);
    }

    @Override
    public void switchTo(String targetId) throws ExecutionException {
        Object[] param = new Object[]{targetId};
        JsonResultWrapper.fromJson((Function)this.operations.get("switchTo").getOperation(), (Object[])param);
    }

    @Override
    public void activate() throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.operations.get("activate").getOperation());
    }

    @Override
    public void passivate() throws ExecutionException {
        JsonResultWrapper.fromJson((Object)this.operations.get("passivate").getOperation());
    }

    @Override
    public void reconfigure(Map<String, String> values) throws ExecutionException {
        Object[] param = new Object[]{AasUtils.writeMap(values)};
        JsonResultWrapper.fromJson((Function)this.operations.get("reconfigure").getOperation(), (Object[])param);
    }
}

