/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment.switching;

import de.iip_ecosphere.platform.services.environment.switching.StartNewStopOld;
import de.iip_ecosphere.platform.services.environment.switching.Strategy;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;

public interface ServiceSelector<T> {
    public String select(T var1);

    default public void actionCompleted(String id) {
    }

    default public void initial(String id) {
    }

    default public Strategy createStrategy() {
        return new StartNewStopOld();
    }

    public static <T> ServiceSelector<T> createInstance(ClassLoader loader, String cls, Class<T> type, String dflt) {
        ServiceSelector<Object> result = null;
        try {
            Class<?> c = loader.loadClass(cls);
            result = (ServiceSelector<Object>)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LoggerFactory.getLogger(ServiceSelector.class).warn("Cannot load selector {}: Falling back to '{}'", (Object)cls, (Object)dflt);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LoggerFactory.getLogger(ServiceSelector.class).warn("Cannot instantiate selector {}: {}. Falling back to '{}'", new Object[]{cls, e.getMessage(), dflt});
        }
        catch (ClassCastException e) {
            LoggerFactory.getLogger(ServiceSelector.class).warn("Instance of {} is not a selector type. Falling back to '{}'", (Object)cls, (Object)dflt);
        }
        if (result == null) {
            result = i -> dflt;
        }
        return result;
    }
}

