/********************************************************************************
 * Copyright (c) {2020} The original author or authors
 *
 * All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License 2.0 which is available 
 * at http://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: Apache-2.0 OR EPL-2.0
 ********************************************************************************/
package test.de.iip_ecosphere.platform.services.spring.plugintests;

import org.junit.runner.RunWith;

import de.iip_ecosphere.platform.services.ServiceFactory;
import junit.framework.TestSuite;
import test.de.iip_ecosphere.platform.support.TestUtils;

/**
 * Defines the tests to be executed independently.
 * 
 * @author Holger Eichelberger, SSE
 */
@RunWith(org.junit.runners.AllTests.class)
public class AllTests4 extends BasicTestWithPlugin {
    
    /**
     * Creates the test suite to execute, called by jUnit.
     * 
     * @return the test suite
     */
    public static TestSuite suite() {
        return TestUtils.suite(ServiceFactory.getTests(4));
    }

}
