/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services;

import de.iip_ecosphere.platform.services.ArtifactDescriptor;
import de.iip_ecosphere.platform.services.ServiceDescriptor;
import de.iip_ecosphere.platform.services.ServiceFactory;
import de.iip_ecosphere.platform.services.ServiceManager;
import de.iip_ecosphere.platform.services.ServiceOperations;
import de.iip_ecosphere.platform.services.TypedDataConnectorDescriptor;
import de.iip_ecosphere.platform.services.TypedDataDescriptor;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.ServiceMapper;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.metricsProvider.metricsAas.MetricsAasConstructor;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.ClassUtility;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.connectors.TransportSetup;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;

public class ServicesAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "services";
    public static final String NAME_SUBMODEL_RESOURCES = "resources";
    public static final String NAME_COLL_ARTIFACTS = "artifacts";
    public static final String NAME_COLL_SERVICES = "services";
    public static final String NAME_COLL_RELATIONS = "relations";
    public static final String NAME_COLL_SERVICE_MANAGERS = "serviceManagers";
    public static final String NAME_SUBCOLL_PARAMETERS = "parameters";
    public static final String NAME_SUBCOLL_INPUT_DATA_CONN = "inputDataConnectors";
    public static final String NAME_SUBCOLL_OUTPUT_DATA_CONN = "outputDataConnectors";
    public static final String NAME_PROP_ID = "id";
    public static final String NAME_PROP_APPLICATION_ID = "applicationId";
    public static final String NAME_PROP_APPLICATION_INSTANCE_ID = "applicationInstanceId";
    public static final String NAME_PROP_SERVICEMGR_ID = "serviceMgr";
    public static final String NAME_PROP_NAME = "name";
    public static final String NAME_PROP_STATE = "state";
    public static final String NAME_PROP_KIND = "kind";
    public static final String NAME_PROP_VERSION = "version";
    public static final String NAME_PROP_DESCRIPTION = "description";
    public static final String NAME_PROP_TYPE = "type";
    public static final String NAME_PROP_RESOURCE = "resource";
    public static final String NAME_PROP_FROM = "from";
    public static final String NAME_PROP_FROM_RESOURCE = "fromResource";
    public static final String NAME_PROP_TO = "to";
    public static final String NAME_PROP_TO_RESOURCE = "toResource";
    public static final String NAME_PROP_ARTIFACT = "artifact";
    public static final String NAME_PROP_TOPLEVEL = "topLevel";
    public static final String NAME_PROP_SERVICE_AAS = "serviceAas";
    public static final String NAME_PROP_DEVICE_AAS = "deviceAas";
    public static final String NAME_PROP_IN_CLEANUP = "inCleanup";
    public static final String NAME_PROP_SUPPORTED_APPIDS = "supportedAppIds";
    public static final String NAME_OP_SVC_GET_STATE = "getState";
    public static final String NAME_OP_SVC_SET_STATE = "setState";
    public static final String NAME_OP_SERVICE_START = "startService";
    public static final String NAME_OP_SERVICE_START_TASK = "startServiceAsTask";
    public static final String NAME_OP_SERVICE_START_WITH_OPTS = "startServiceWithOptions";
    public static final String NAME_OP_SERVICE_START_WITH_OPTS_TASK = "startServiceWithOptionsAsTask";
    public static final String NAME_OP_SERVICE_ACTIVATE = "activateService";
    public static final String NAME_OP_SERVICE_PASSIVATE = "passivateService";
    public static final String NAME_OP_SERVICE_MIGRATE = "migrateService";
    public static final String NAME_OP_SERVICE_UPDATE = "updateService";
    public static final String NAME_OP_SERVICE_SWITCH = "switchToService";
    public static final String NAME_OP_SERVICE_RECONF = "reconfigureService";
    public static final String NAME_OP_SERVICE_STOP = "stopService";
    public static final String NAME_OP_SERVICE_STOP_TASK = "stopServiceAsTask";
    public static final String NAME_OP_SERVICE_GET_STATE = "getServiceState";
    public static final String NAME_OP_SERVICE_SET_STATE = "setServiceState";
    public static final String NAME_OP_ARTIFACT_ADD = "addArtifact";
    public static final String NAME_OP_ARTIFACT_ADD_TASK = "addArtifactAsTask";
    public static final String NAME_OP_ARTIFACT_REMOVE = "removeArtifact";
    public static final String NAME_OP_ARTIFACT_REMOVE_TASK = "removeArtifactAsTask";
    public static final String NAME_OP_SERVICE_INSTANCE_COUNT = "getServiceInstanceCount";
    public static final String NAME_OP_SERVICE_STATE_COUNT = "getServiceStateCount";
    public static final String NAME_OP_SERVICE_STREAM_LOG = "serviceStreamLog";
    private static final Set<ServiceState> ERROR_IF_NOT_FOUND = Set.of(ServiceState.FAILED, ServiceState.RUNNING, ServiceState.STOPPING, ServiceState.PASSIVATING, ServiceState.PASSIVATED, ServiceState.RECONFIGURING, ServiceState.RECOVERED, ServiceState.RECOVERING, ServiceState.MIGRATING);

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        ServiceManager mgr = ServiceFactory.getServiceManager();
        if (null != mgr) {
            Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)NAME_SUBMODEL_RESOURCES);
            SubmodelElementCollection.SubmodelElementCollectionBuilder deviceB = smB.createSubmodelElementCollectionBuilder(Id.getDeviceIdAas());
            if (!deviceB.hasElement(NAME_PROP_SUPPORTED_APPIDS)) {
                this.createServiceManagerSubmodelElements(deviceB, iCreator);
            }
            SubmodelElementCollection.SubmodelElementCollectionBuilder svcMgrsB = deviceB.createSubmodelElementCollectionBuilder(NAME_COLL_SERVICE_MANAGERS);
            SubmodelElementCollection.SubmodelElementCollectionBuilder svcMgrB = svcMgrsB.createSubmodelElementCollectionBuilder(Id.getEnvIdAas());
            this.createServiceManagerSubmodelElements(svcMgrB, iCreator);
            svcMgrB.build();
            svcMgrsB.build();
            deviceB.build();
            smB.defer();
            smB = AasPartRegistry.createSubmodelBuilder((Aas.AasBuilder)aasBuilder, (String)"services");
            smB.createSubmodelElementCollectionBuilder("services").build();
            smB.createSubmodelElementCollectionBuilder(NAME_COLL_ARTIFACTS).build();
            smB.createSubmodelElementCollectionBuilder(NAME_COLL_RELATIONS).build();
            for (ArtifactDescriptor artifactDescriptor : mgr.getArtifacts()) {
                ServicesAas.addArtifact(smB, artifactDescriptor);
            }
            for (ServiceDescriptor serviceDescriptor : mgr.getServices()) {
                ServicesAas.addService(smB, serviceDescriptor);
            }
            smB.build();
        }
        return null;
    }

    private void createServiceManagerSubmodelElements(SubmodelElementCollection.SubmodelElementCollectionBuilder builder, InvocablesCreator iCreator) {
        this.createIdOp(builder, NAME_OP_SERVICE_START, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_SERVICE_START_TASK, iCreator, "taskId");
        this.createIdOp(builder, NAME_OP_SERVICE_START_WITH_OPTS, iCreator, "options");
        this.createIdOp(builder, NAME_OP_SERVICE_START_WITH_OPTS_TASK, iCreator, "taskId", "options");
        this.createIdOp(builder, NAME_OP_SERVICE_ACTIVATE, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_SERVICE_PASSIVATE, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_SERVICE_MIGRATE, iCreator, "location");
        this.createIdOp(builder, NAME_OP_SERVICE_UPDATE, iCreator, "location");
        this.createIdOp(builder, NAME_OP_SERVICE_SWITCH, iCreator, "newId");
        this.createIdOp(builder, NAME_OP_SERVICE_RECONF, iCreator, "values");
        this.createIdOp(builder, NAME_OP_SERVICE_STOP, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_SERVICE_STOP_TASK, iCreator, "taskId");
        this.createIdOp(builder, NAME_OP_SERVICE_GET_STATE, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_SERVICE_STREAM_LOG, iCreator, "mode");
        this.createIdOp(builder, NAME_OP_SERVICE_INSTANCE_COUNT, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_SERVICE_SET_STATE, iCreator, NAME_PROP_STATE);
        builder.createOperationBuilder(NAME_OP_ARTIFACT_ADD).setInvocable(iCreator.createInvocable(ServicesAas.getQName(NAME_OP_ARTIFACT_ADD))).addInputVariable("url", Type.STRING).addOutputVariable("result", Type.STRING).build(this.getSubmodelAuthentication());
        builder.createOperationBuilder(NAME_OP_ARTIFACT_ADD_TASK).setInvocable(iCreator.createInvocable(ServicesAas.getQName(NAME_OP_ARTIFACT_ADD_TASK))).addInputVariable("url", Type.STRING).addInputVariable("taskId", Type.STRING).addOutputVariable("result", Type.STRING).build(this.getSubmodelAuthentication());
        builder.createOperationBuilder(NAME_OP_SERVICE_INSTANCE_COUNT).setInvocable(iCreator.createInvocable(ServicesAas.getQName(NAME_OP_SERVICE_INSTANCE_COUNT))).addInputVariable(NAME_PROP_ID, Type.STRING).build(Type.STRING, this.getSubmodelAuthentication());
        builder.createOperationBuilder(NAME_OP_SERVICE_STATE_COUNT).setInvocable(iCreator.createInvocable(ServicesAas.getQName(NAME_OP_SERVICE_STATE_COUNT))).addInputVariable(NAME_PROP_STATE, Type.STRING).build(Type.STRING, this.getSubmodelAuthentication());
        this.createIdOp(builder, NAME_OP_ARTIFACT_REMOVE, iCreator, new String[0]);
        this.createIdOp(builder, NAME_OP_ARTIFACT_REMOVE_TASK, iCreator, "taskId");
        builder.createPropertyBuilder(NAME_PROP_SUPPORTED_APPIDS).setValue(Type.STRING, (Object)String.join((CharSequence)",", ServiceFactory.getSetup().getSupportedAppIds())).build();
    }

    private void createIdOp(SubmodelElementCollection.SubmodelElementCollectionBuilder smB, String name, InvocablesCreator iCreator, String ... otherParams) {
        Operation.OperationBuilder oBuilder = smB.createOperationBuilder(name).setInvocable(iCreator.createInvocable(ServicesAas.getQName(name))).addInputVariable(NAME_PROP_ID, Type.STRING);
        for (String p : otherParams) {
            oBuilder.addInputVariable(p, Type.STRING);
        }
        oBuilder.addOutputVariable("result", Type.STRING).build(this.getSubmodelAuthentication());
    }

    public static String getQName(String elementName) {
        return "services_" + elementName;
    }

    private static String[] readStringArray(Object[] args, int index) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        return null == param ? new String[]{} : (String[])JsonUtils.fromJson((Object)param.toString(), String[].class);
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_START), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().startService(ServicesAas.readStringArray(p, 0));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_START_WITH_OPTS), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().startService(AasUtils.readMap((Object[])p, (int)1, null), ServicesAas.readStringArray(p, 0));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_ACTIVATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().activateService(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_PASSIVATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().passivateService(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_MIGRATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().migrateService(AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_UPDATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().updateService(AasUtils.readString((Object[])p), AasUtils.readUri((Object[])p, (int)1, (URI)AasUtils.EMPTY_URI));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_SWITCH), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().switchToService(AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_RECONF), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().reconfigureService(AasUtils.readString((Object[])p, (int)0, (String)""), AasUtils.readMap((Object[])p, (int)1, null));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_STOP), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().stopService(ServicesAas.readStringArray(p, 0));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_GET_STATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> ServiceFactory.getServiceManager().getServiceState(AasUtils.readString((Object[])p))));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_STREAM_LOG), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> ServiceFactory.getServiceManager().streamLog(AasUtils.readString((Object[])p), ServiceOperations.toMode(AasUtils.readString((Object[])p, (int)1)))));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_INSTANCE_COUNT), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> ServiceFactory.getServiceManager().getServiceInstanceCount(AasUtils.readString((Object[])p))));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_STATE_COUNT), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> ServicesAas.getServiceStateCount(AasUtils.readString((Object[])p, (int)0, (String)""))));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_SET_STATE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceState state = ServiceState.valueOf((String)AasUtils.readString((Object[])p, (int)1, (String)""));
            ServiceFactory.getServiceManager().setServiceState(AasUtils.readString((Object[])p), state);
            return null;
        }));
        this.contributeArtifactTo(sBuilder);
        this.contributeTaskTo(sBuilder);
    }

    private static int getServiceStateCount(String state) {
        int count = 0;
        if (null != state) {
            try {
                ServiceManager mgr = ServiceFactory.getServiceManager();
                ServiceState st = ServiceState.valueOf((String)state);
                for (String id : mgr.getServiceIds()) {
                    if (st != mgr.getServiceState(id)) continue;
                    ++count;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return count;
    }

    private void contributeArtifactTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_ARTIFACT_ADD), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> ServiceFactory.getServiceManager().addArtifact(AasUtils.readUri((Object[])p, (int)0, (URI)AasUtils.EMPTY_URI))));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_ARTIFACT_ADD_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> ServiceFactory.getServiceManager().addArtifact(AasUtils.readUri((Object[])p, (int)0, (URI)AasUtils.EMPTY_URI)), p -> AasUtils.readString((Object[])p, (int)1)));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_ARTIFACT_REMOVE), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().removeArtifact(AasUtils.readString((Object[])p));
            return null;
        }));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_ARTIFACT_REMOVE_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().removeArtifact(AasUtils.readString((Object[])p));
            return null;
        }, p -> AasUtils.readString((Object[])p, (int)1)));
    }

    private void contributeTaskTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_START_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().startService(ServicesAas.readStringArray(p, 0));
            return null;
        }, p -> AasUtils.readString((Object[])p, (int)1)));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_START_WITH_OPTS_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().startService(AasUtils.readMap((Object[])p, (int)2, null), ServicesAas.readStringArray(p, 0));
            return null;
        }, p -> AasUtils.readString((Object[])p, (int)1)));
        sBuilder.defineOperation(ServicesAas.getQName(NAME_OP_SERVICE_STOP_TASK), (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)p -> {
            ServiceFactory.getServiceManager().stopService(ServicesAas.readStringArray(p, 0));
            return null;
        }, p -> AasUtils.readString((Object[])p, (int)1)));
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    private static void addArtifact(Submodel.SubmodelBuilder smB, ArtifactDescriptor desc) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder cBuilder = smB.createSubmodelElementCollectionBuilder(NAME_COLL_ARTIFACTS);
        SubmodelElementCollection.SubmodelElementCollectionBuilder dBuilder = cBuilder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)desc.getId()));
        dBuilder.createPropertyBuilder(NAME_PROP_ID).setValue(Type.STRING, (Object)desc.getId()).build();
        dBuilder.createPropertyBuilder(NAME_PROP_NAME).setValue(Type.STRING, (Object)desc.getName()).build();
        dBuilder.createPropertyBuilder(NAME_PROP_RESOURCE).setValue(Type.STRING, (Object)Id.getDeviceIdAas()).build();
        dBuilder.build();
        cBuilder.build();
    }

    private static void addService(Submodel.SubmodelBuilder smB, ServiceDescriptor desc) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder serviceBuilder = smB.createSubmodelElementCollectionBuilder("services");
        String serviceId = AasUtils.fixId((String)desc.getId());
        SubmodelElementCollection.SubmodelElementCollectionBuilder descriptorBuilder = serviceBuilder.createSubmodelElementCollectionBuilder(serviceId);
        descriptorBuilder.createPropertyBuilder(NAME_PROP_ID).setValue(Type.STRING, (Object)desc.getId()).build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_APPLICATION_ID).setValue(Type.STRING, (Object)desc.getApplicationId()).build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_APPLICATION_INSTANCE_ID).setValue(Type.STRING, (Object)desc.getApplicationInstanceId()).build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_SERVICEMGR_ID).setValue(Type.STRING, (Object)Id.getEnvId()).build();
        if (null != desc.getArtifact()) {
            descriptorBuilder.createPropertyBuilder(NAME_PROP_ARTIFACT).setValue(Type.STRING, (Object)desc.getArtifact().getId()).build();
        }
        descriptorBuilder.createPropertyBuilder(NAME_PROP_TOPLEVEL).setValue(Type.BOOLEAN, (Object)desc.isTopLevel()).build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_NAME).setValue(Type.STRING, (Object)desc.getName()).setSemanticId("0173-1#02-AAO247#002").build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_STATE).setValue(Type.STRING, (Object)desc.getState().toString()).build();
        ServicesAas.addServiceOperations(descriptorBuilder, desc);
        AasUtils.ifEarlyAas(() -> desc.getApplicationInstanceId().length() == 0, () -> desc.attachAction(ServiceDescriptor.Action.COMMUNICATION_DETERMINED, () -> ServicesAas.defineServiceOperations(desc, null)), null);
        descriptorBuilder.createPropertyBuilder(NAME_PROP_KIND).setValue(Type.STRING, (Object)desc.getKind().toString()).build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_VERSION).setValue(Type.STRING, (Object)desc.getVersion().toString()).setSemanticId("0173-1#02-AAM737#002").build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_DESCRIPTION).setValue(Type.STRING, (Object)desc.getDescription()).build();
        descriptorBuilder.createPropertyBuilder(NAME_PROP_RESOURCE).setValue(Type.STRING, (Object)Id.getDeviceIdAas()).build();
        Registry reg = AasPartRegistry.getIipAasRegistry();
        AasPartRegistry.addServiceAasEndpointProperty((Registry)reg, (SubmodelElementContainerBuilder)descriptorBuilder, (String)NAME_PROP_SERVICE_AAS, (String)desc.getId());
        AasPartRegistry.addDeviceAasEndpointProperty((Registry)reg, (SubmodelElementContainerBuilder)descriptorBuilder, (String)NAME_PROP_DEVICE_AAS, (String)Id.getDeviceIdAas());
        ServicesAas.addTypedData(descriptorBuilder, NAME_SUBCOLL_PARAMETERS, desc.getParameters());
        ServicesAas.addTypedData(descriptorBuilder, NAME_SUBCOLL_INPUT_DATA_CONN, desc.getInputDataConnectors());
        ServicesAas.addTypedData(descriptorBuilder, NAME_SUBCOLL_OUTPUT_DATA_CONN, desc.getOutputDataConnectors());
        AasUtils.ifEarlyAas(() -> ServicesAas.registerMetrics(descriptorBuilder));
        descriptorBuilder.build();
        serviceBuilder.build();
        Transport.sendServiceStatusWithDescription((ActionType)ActionTypes.ADDED, (String)desc.getId(), (String)desc.getState().toString(), (String[])new String[0]);
        ServicesAas.getLogger().info("Service information added for `{}` (idShort: {})", (Object)desc.getId(), (Object)serviceId);
    }

    private static void addServiceOperations(SubmodelElementCollection.SubmodelElementCollectionBuilder descriptorBuilder, ServiceDescriptor desc) {
        InvocablesCreator iCreator = desc.getInvocablesCreator();
        descriptorBuilder.createOperationBuilder(NAME_OP_SVC_SET_STATE).addInputVariable(NAME_PROP_STATE, Type.STRING).setInvocable(iCreator.createInvocable(ServiceMapper.getQName((String)desc.getId(), (String)NAME_OP_SVC_SET_STATE))).build(AasPartRegistry.getSubmodelAuthentication());
        descriptorBuilder.createOperationBuilder(NAME_OP_SVC_GET_STATE).setInvocable(iCreator.createInvocable(ServiceMapper.getQName((String)desc.getId(), (String)NAME_OP_SVC_GET_STATE))).build(Type.STRING, AasPartRegistry.getSubmodelAuthentication());
    }

    private static void defineServiceOperations(ServiceDescriptor desc, ActiveAasBase.NotificationMode mode) {
        ActiveAasBase.processNotification((String)"services", (ActiveAasBase.NotificationMode)mode, (sub, aas) -> {
            String serviceId = AasUtils.fixId((String)desc.getId());
            InvocablesCreator iCreator = desc.getInvocablesCreator();
            SubmodelElementCollection.SubmodelElementCollectionBuilder subB = sub.createSubmodelElementCollectionBuilder("services");
            SubmodelElementCollection.SubmodelElementCollectionBuilder eltB = subB.createSubmodelElementCollectionBuilder(serviceId);
            eltB.createOperationBuilder(NAME_OP_SVC_SET_STATE).addInputVariable(NAME_PROP_STATE, Type.STRING).setInvocable(iCreator.createInvocable(ServiceMapper.getQName((String)desc.getId(), (String)NAME_OP_SVC_SET_STATE))).build(AasPartRegistry.getSubmodelAuthentication());
            eltB.createOperationBuilder(NAME_OP_SVC_GET_STATE).setInvocable(iCreator.createInvocable(ServiceMapper.getQName((String)desc.getId(), (String)NAME_OP_SVC_GET_STATE))).build(Type.STRING, AasPartRegistry.getSubmodelAuthentication());
        });
    }

    private static void addTypedData(SubmodelElementCollection.SubmodelElementCollectionBuilder builder, String name, List<? extends TypedDataDescriptor> descriptors) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder pBuilder = builder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)name));
        for (TypedDataDescriptor typedDataDescriptor : descriptors) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder dBuilder = builder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)typedDataDescriptor.getName()));
            dBuilder.createPropertyBuilder(NAME_PROP_NAME).setValue(Type.STRING, (Object)typedDataDescriptor.getName()).build();
            dBuilder.createPropertyBuilder(NAME_PROP_DESCRIPTION).setValue(Type.STRING, (Object)typedDataDescriptor.getDescription()).build();
            if (null != typedDataDescriptor.getType()) {
                ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)dBuilder, (String)NAME_PROP_TYPE, typedDataDescriptor.getType());
            }
            dBuilder.build();
        }
        pBuilder.build();
    }

    private static void addRelationData(SubmodelElementCollection.SubmodelElementCollectionBuilder builder, List<? extends TypedDataConnectorDescriptor> descriptors, boolean input, Reference serviceRef) {
        for (TypedDataConnectorDescriptor typedDataConnectorDescriptor : descriptors) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder dBuilder = builder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)typedDataConnectorDescriptor.getName()));
            String name = input ? NAME_PROP_TO : NAME_PROP_FROM;
            dBuilder.createReferenceElementBuilder(name).setValue(serviceRef).build();
            name = input ? NAME_PROP_TO_RESOURCE : NAME_PROP_FROM_RESOURCE;
            dBuilder.createPropertyBuilder(name).setValue(Type.STRING, (Object)Id.getDeviceIdAas()).build();
            dBuilder.defer();
        }
    }

    public static Predicate<TypedDataConnectorDescriptor> createAvailabilityPredicate(final int timeout, final int retryDelay, final boolean input) {
        return new Predicate<TypedDataConnectorDescriptor>(){
            private SubmodelElementCollection rels;

            @Override
            public boolean test(TypedDataConnectorDescriptor conn) {
                boolean found = false;
                long start = System.currentTimeMillis();
                do {
                    if (null == this.rels) {
                        try {
                            Submodel submodel = ActiveAasBase.getSubmodel((String)"services");
                            this.rels = submodel.getSubmodelElementCollection(ServicesAas.NAME_COLL_RELATIONS);
                        }
                        catch (IOException submodel) {
                            // empty catch block
                        }
                    }
                    if (null != this.rels) {
                        this.rels.update();
                        SubmodelElementCollection rel = this.rels.getSubmodelElementCollection(AasUtils.fixId((String)conn.getName()));
                        if (null != rel) {
                            String name = input ? ServicesAas.NAME_PROP_TO : ServicesAas.NAME_PROP_FROM;
                            boolean bl = found = null != rel.getReferenceElement(name);
                        }
                    }
                    if (found || timeout <= 0) continue;
                    TimeUtils.sleep((int)retryDelay);
                } while (!found && System.currentTimeMillis() - start < (long)timeout);
                return found;
            }
        };
    }

    public static void notifyArtifactAdded(ArtifactDescriptor desc) {
        ActiveAasBase.processNotification((String)"services", (sub, aas) -> {
            Submodel.SubmodelBuilder builder = AasPartRegistry.createSubmodelBuilder((Aas)aas, (String)"services");
            ServicesAas.addArtifact(builder, desc);
            ArrayList<? extends ServiceDescriptor> sTmp = new ArrayList<ServiceDescriptor>(desc.getServices());
            for (ServiceDescriptor serviceDescriptor : sTmp) {
                ServicesAas.addService(builder, serviceDescriptor);
            }
            sTmp.clear();
            sTmp.addAll(desc.getServers());
            for (ServiceDescriptor serviceDescriptor : sTmp) {
                ServicesAas.addService(builder, serviceDescriptor);
            }
        });
        Transport.sendServiceArtifactStatus((ActionType)ActionTypes.ADDED, (String)desc.getId(), (String[])new String[0]);
    }

    public static void notifyServiceAdded(ServiceDescriptor desc) {
        ActiveAasBase.processNotification((String)"services", (sub, aas) -> {
            Submodel.SubmodelBuilder builder = AasPartRegistry.createSubmodelBuilder((Aas)aas, (String)"services");
            ServicesAas.addService(builder, desc);
        });
        Transport.sendServiceStatus((ActionType)ActionTypes.ADDED, (String)desc.getId(), (String[])new String[0]);
    }

    public static void notifyArtifactRemoved(ArtifactDescriptor desc) {
        ActiveAasBase.processNotification((String)"services", (sub, aas) -> ServicesAas.removeArtifact(sub, desc));
    }

    private static void removeArtifact(Submodel sub, ArtifactDescriptor desc) {
        SubmodelElementCollection coll = sub.getSubmodelElementCollection("services");
        for (String string : desc.getServiceIds()) {
            coll.deleteElement(AasUtils.fixId((String)string));
        }
        coll = sub.getSubmodelElementCollection(NAME_COLL_ARTIFACTS);
        coll.deleteElement(AasUtils.fixId((String)desc.getId()));
        coll = sub.getSubmodelElementCollection(NAME_COLL_RELATIONS);
        for (ServiceDescriptor serviceDescriptor : desc.getServices()) {
            ServicesAas.removeRelations(serviceDescriptor, sub, coll);
        }
        Transport.sendServiceArtifactStatus((ActionType)ActionTypes.REMOVED, (String)desc.getId(), (String[])new String[0]);
        ServicesAas.getLogger().info("Artifact `{}` removed", (Object)desc.getId());
    }

    public static void notifyManagerRemoved() {
        ActiveAasBase.processNotification((String)"services", (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS, (sub, aas) -> {
            ServiceManager mgr = ServiceFactory.getServiceManager();
            for (ArtifactDescriptor artifactDescriptor : mgr.getArtifacts()) {
                ServicesAas.removeArtifact(sub, artifactDescriptor);
            }
        });
    }

    private static SubmodelElementCollection removeRelations(ServiceDescriptor service, Submodel sub, SubmodelElementCollection coll) {
        if (null == coll) {
            coll = sub.getSubmodelElementCollection(NAME_COLL_RELATIONS);
        }
        for (TypedDataConnectorDescriptor c : service.getInputDataConnectors()) {
            ServicesAas.deleteSubmodelElement(coll, c.getName(), NAME_PROP_TO);
            ServicesAas.deleteSubmodelElement(coll, c.getName(), NAME_PROP_TO_RESOURCE);
        }
        for (TypedDataConnectorDescriptor c : service.getOutputDataConnectors()) {
            ServicesAas.deleteSubmodelElement(coll, c.getName(), NAME_PROP_FROM);
            ServicesAas.deleteSubmodelElement(coll, c.getName(), NAME_PROP_FROM_RESOURCE);
        }
        return coll;
    }

    private static void removeService(ServiceDescriptor service, Submodel sub) {
        SubmodelElementCollection coll;
        String appInstId = service.getApplicationInstanceId();
        if (appInstId != null && appInstId.length() > 0 && null != (coll = sub.getSubmodelElementCollection("services"))) {
            coll.deleteElement(AasUtils.fixId((String)service.getId()));
        }
    }

    private static void deleteSubmodelElement(SubmodelElementCollection coll, String name, String elt) {
        SubmodelElementCollection c = coll.getSubmodelElementCollection(AasUtils.fixId((String)name));
        String eltId = AasUtils.fixId((String)elt);
        if (null != c && c.getElement(eltId) != null) {
            c.deleteElement(eltId);
        }
    }

    public static void notifyServiceStateChanged(ServiceState old, ServiceState act, ServiceDescriptor desc) {
        ServicesAas.notifyServiceStateChanged(old, act, desc, null);
    }

    public static void notifyServiceStateChanged(ServiceState old, ServiceState act, ServiceDescriptor desc, ActiveAasBase.NotificationMode mode) {
        ActiveAasBase.processNotification((String)"services", (ActiveAasBase.NotificationMode)mode, (sub, aas) -> {
            SubmodelElementCollection services = sub.getSubmodelElementCollection("services");
            String serviceId = AasUtils.fixId((String)desc.getId());
            SubmodelElementCollection elt = services.getSubmodelElementCollection(serviceId);
            String actName = ServiceState.toString((ServiceState)act);
            if (null != elt) {
                Property prop;
                boolean logError = act != null && ERROR_IF_NOT_FOUND.contains(act) && desc.getKind() != ServiceKind.SERVER;
                Operation op = elt.getOperation(NAME_OP_SVC_SET_STATE);
                if (null != op) {
                    try {
                        op.invoke(new Object[]{actName});
                    }
                    catch (ExecutionException e) {
                        if (logError) {
                            ServicesAas.getLogger().error("Cannot set state for service `{}`: {}", (Object)desc.getId(), (Object)e.getMessage());
                        }
                    }
                } else if (logError) {
                    ServicesAas.getLogger().error("Service state change - cannot find operation {} for service `{}`. Deployment descriptor ok? Network port reserved?", (Object)NAME_OP_SVC_SET_STATE, (Object)desc.getId());
                }
                if (null != (prop = elt.getProperty(NAME_PROP_STATE))) {
                    try {
                        prop.setValue((Object)actName);
                    }
                    catch (ExecutionException e) {
                        if (logError) {
                            ServicesAas.getLogger().warn("Cannot write state for service `{}`: {}", (Object)desc.getId(), (Object)e.getMessage());
                        }
                    }
                } else if (logError) {
                    ServicesAas.getLogger().warn("Service state change - cannot find property {} for service `{}`", (Object)NAME_PROP_STATE, (Object)desc.getId());
                }
            } else {
                ServicesAas.getLogger().error("Service state change - cannot find service `{}` (idShort: {})", (Object)desc.getId(), (Object)serviceId);
            }
            ServicesAas.getLogger().info("Handling service state change `{}`: {} -> {}", new Object[]{desc.getId(), old, act});
            if (ServiceState.AVAILABLE == old && ServiceState.STARTING == act) {
                AasUtils.ifEarlyAas(null, () -> ServicesAas.registerMetrics(desc, sub, elt));
                Transport.sendServiceStatusWithDescription((ActionType)ActionTypes.CHANGED, (String)desc.getId(), (String)actName, (String[])new String[0]);
            } else if (ServiceState.STARTING == old && ServiceState.RUNNING == act) {
                ServicesAas.setupRelations(desc, sub, elt);
                Transport.sendServiceStatusWithDescription((ActionType)ActionTypes.CHANGED, (String)desc.getId(), (String)actName, (String[])new String[0]);
            } else if ((ServiceState.RUNNING == old || ServiceState.FAILED == old) && ServiceState.STOPPED == act) {
                ServicesAas.removeRelations(desc, sub, null);
                ServicesAas.removeService(desc, sub);
                Transport.sendServiceStatusWithDescription((ActionType)ActionTypes.REMOVED, (String)desc.getId(), (String)actName, (String[])new String[0]);
            } else if ((ServiceState.RUNNING == old || ServiceState.FAILED == old) && ServiceState.STOPPING == act) {
                AasUtils.ifEarlyAas(() -> MetricsAasConstructor.clearProviderMetricsInAasSubmodel((SubmodelElementCollection)elt), () -> MetricsAasConstructor.removeProviderMetricsFromAasSubmodel((SubmodelElementCollection)elt));
                Transport.sendServiceStatusWithDescription((ActionType)ActionTypes.CHANGED, (String)desc.getId(), (String)actName, (String[])new String[0]);
            } else if (old != act) {
                Transport.sendServiceStatusWithDescription((ActionType)ActionTypes.CHANGED, (String)desc.getId(), (String)actName, (String[])new String[0]);
            }
        });
    }

    private static void registerMetrics(ServiceDescriptor desc, Submodel sub, SubmodelElementCollection elt) {
        if (!MetricsAasConstructor.containsMetrics((SubmodelElementCollection)elt)) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder serviceB = sub.createSubmodelElementCollectionBuilder("services");
            SubmodelElementCollection.SubmodelElementCollectionBuilder subB = serviceB.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)desc.getId()));
            ServicesAas.registerMetrics(subB);
            subB.build();
        }
    }

    private static void registerMetrics(SubmodelElementCollection.SubmodelElementCollectionBuilder subB) {
        String devId = Id.getDeviceId();
        TransportSetup tSetup = ServiceFactory.getTransport();
        MetricsAasConstructor.addProviderMetricsToAasSubmodel((SubmodelElementContainerBuilder)subB, null, (String)"ServiceMetrics", (String)devId, (TransportSetup)tSetup);
        MetricsAasConstructor.addServiceMetricsToAasSubmodel((SubmodelElementContainerBuilder)subB, null, (String)"ServiceMetrics", (String)devId, (TransportSetup)tSetup);
    }

    private static void setupRelations(ServiceDescriptor desc, Submodel sub, SubmodelElementCollection elt) {
        Reference serviceRef = elt.createReference();
        SubmodelElementCollection.SubmodelElementCollectionBuilder connectionBuilder = sub.createSubmodelElementCollectionBuilder(NAME_COLL_RELATIONS);
        ServicesAas.addRelationData(connectionBuilder, desc.getInputDataConnectors(), true, serviceRef);
        ServicesAas.addRelationData(connectionBuilder, desc.getOutputDataConnectors(), false, serviceRef);
        connectionBuilder.build();
    }

    public static void removeDevice(String deviceId) {
        ActiveAasBase.processNotification((String)"services", (ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.SYNCHRONOUS, (sub, aas) -> ServicesAas.removeDevice(sub, deviceId));
    }

    public static void removeDevice(Submodel sub, String deviceId) {
        String aasDeviceId = AasUtils.fixId((String)deviceId);
        Predicate pred = ActiveAasBase.createPropertyPredicate((String)NAME_PROP_RESOURCE, (Object)aasDeviceId, (String)("While deleting resource " + deviceId));
        SubmodelElementCollection coll = sub.getSubmodelElementCollection(NAME_COLL_ARTIFACTS);
        ActiveAasBase.clearCollection((SubmodelElementCollection)coll, (Predicate)pred);
        coll = sub.getSubmodelElementCollection("services");
        ActiveAasBase.clearCollection((SubmodelElementCollection)coll, (Predicate)pred);
        coll = sub.getSubmodelElementCollection(NAME_COLL_RELATIONS);
        ServicesAas.clearRelations(coll, aasDeviceId, deviceId);
    }

    private static void clearRelations(SubmodelElementCollection coll, String aasDeviceId, String deviceId) {
        if (null != coll) {
            for (SubmodelElement e : coll.elements()) {
                if (!(e instanceof SubmodelElementCollection)) continue;
                SubmodelElementCollection ec = (SubmodelElementCollection)e;
                try {
                    if (aasDeviceId.equals(ec.getProperty(NAME_PROP_FROM_RESOURCE).getValue())) {
                        ec.deleteElement(NAME_PROP_FROM_RESOURCE);
                        ec.deleteElement(NAME_PROP_FROM);
                        continue;
                    }
                    if (!aasDeviceId.equals(ec.getProperty(NAME_PROP_TO_RESOURCE).getValue())) continue;
                    ec.deleteElement(NAME_PROP_TO_RESOURCE);
                    ec.deleteElement(NAME_PROP_TO);
                }
                catch (ExecutionException ex) {
                    LoggerFactory.getLogger(ServicesAas.class).error("While deleting device {}: {} ", (Object)deviceId, (Object)ex.getMessage());
                }
            }
        }
    }

    public static void setCleanup(Submodel sm, String deviceId) {
        Property prop;
        String aasDeviceId = AasUtils.fixId((String)deviceId);
        SubmodelElementCollection sec = sm.getSubmodelElementCollection(aasDeviceId);
        if (null != sec && null != (prop = sec.getProperty(NAME_PROP_IN_CLEANUP))) {
            try {
                prop.setValue((Object)true);
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(ServicesAas.class).warn("Cannot set {}:{}", (Object)NAME_PROP_IN_CLEANUP, (Object)e.getMessage());
            }
        }
    }

    public static void deferForCleanup(SubmodelElementCollection.SubmodelElementCollectionBuilder smBuilder) {
        boolean inCleanup = false;
        Property.PropertyBuilder builder = smBuilder.createPropertyBuilder(NAME_PROP_IN_CLEANUP);
        do {
            try {
                Object tmp = builder.getValue();
                if (!(tmp instanceof Boolean) || !(inCleanup = ((Boolean)tmp).booleanValue())) continue;
                LoggerFactory.getLogger(ServicesAas.class).info("Device in cleanup. Deferring AAS creation by 500 ms.");
                TimeUtils.sleep((int)500);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        } while (inCleanup);
        builder.setValue(Type.BOOLEAN, (Object)false);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ServicesAas.class);
    }

    public boolean isValid() {
        return ServiceFactory.getServiceManager() != null;
    }
}

