/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.memory.IRegistryHandler;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBRegistryHandler
implements IRegistryHandler {
    private static final String DEFAULT_CONFIG_PATH = "mongodb.properties";
    protected BaSyxMongoDBConfiguration config;
    protected MongoOperations mongoOps;
    protected String collection;
    private static final String AASID = "identification.id";
    private static final String ASSETID = "asset.identification.id";

    public MongoDBRegistryHandler(BaSyxMongoDBConfiguration config) {
        this.setConfiguration(config);
    }

    public MongoDBRegistryHandler(String resourceConfigPath) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config);
    }

    public MongoDBRegistryHandler() {
        this(DEFAULT_CONFIG_PATH);
    }

    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.config = config;
        MongoClient client = MongoClients.create((String)config.getConnectionUrl());
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
        this.collection = config.getRegistryCollection();
    }

    public boolean contains(IIdentifier identifier) {
        String id = identifier.getId();
        Criteria hasId = new Criteria();
        hasId.orOperator(new Criteria[]{Criteria.where((String)AASID).is((Object)id), Criteria.where((String)ASSETID).is((Object)id)});
        return this.mongoOps.exists(Query.query((CriteriaDefinition)hasId), this.collection);
    }

    public void remove(IIdentifier identifier) {
        String id = identifier.getId();
        Criteria hasId = new Criteria();
        hasId.orOperator(new Criteria[]{Criteria.where((String)AASID).is((Object)id), Criteria.where((String)ASSETID).is((Object)id)});
        this.mongoOps.remove(Query.query((CriteriaDefinition)hasId), this.collection);
    }

    public void insert(AASDescriptor descriptor) {
        this.mongoOps.insert((Object)descriptor, this.collection);
    }

    public void update(AASDescriptor descriptor) {
        String aasId = descriptor.getIdentifier().getId();
        Object result = this.mongoOps.findAndReplace(Query.query((CriteriaDefinition)Criteria.where((String)AASID).is((Object)aasId)), (Object)descriptor, this.collection);
        if (result == null) {
            this.insert(descriptor);
        }
    }

    public AASDescriptor get(IIdentifier identifier) {
        String id = identifier.getId();
        Criteria hasId = new Criteria();
        hasId.orOperator(new Criteria[]{Criteria.where((String)AASID).is((Object)id), Criteria.where((String)ASSETID).is((Object)id)});
        AASDescriptor result = (AASDescriptor)this.mongoOps.findOne(Query.query((CriteriaDefinition)hasId), AASDescriptor.class, this.collection);
        if (result != null) {
            result.remove((Object)"_id");
        }
        return result;
    }

    public List<AASDescriptor> getAll() {
        List result = this.mongoOps.findAll(AASDescriptor.class, this.collection);
        result.forEach(desc -> desc.remove((Object)"_id"));
        return result;
    }
}

