/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.mqtt;

import java.util.List;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttAASRegistryService
extends MqttEventService
implements IAASRegistry {
    private static Logger logger = LoggerFactory.getLogger(MqttAASRegistryService.class);
    public static final String TOPIC_REGISTERAAS = "BaSyxRegistry_registeredAAS";
    public static final String TOPIC_REGISTERSUBMODEL = "BaSyxRegistry_registeredSubmodel";
    public static final String TOPIC_DELETEAAS = "BaSyxRegistry_deletedAAS";
    public static final String TOPIC_DELETESUBMODEL = "BaSyxRegistry_deletedSubmodel";
    protected IAASRegistry observedRegistryService;

    public MqttAASRegistryService(IAASRegistry observedRegistryService, String serverEndpoint, String clientId) throws MqttException {
        super(serverEndpoint, clientId);
        logger.info("Create new MQTT AAS Registry Service for endpoint " + serverEndpoint);
        this.observedRegistryService = observedRegistryService;
    }

    public MqttAASRegistryService(IAASRegistry observedRegistryService, String serverEndpoint, String clientId, String user, char[] pw) throws MqttException {
        super(serverEndpoint, clientId, user, pw);
        logger.info("Create new MQTT AAS Registry Service for endpoint " + serverEndpoint);
        this.observedRegistryService = observedRegistryService;
    }

    public MqttAASRegistryService(IAASRegistry observedRegistryService, MqttClient client) throws MqttException {
        super(client);
        logger.info("Create new MQTT AAS Registry Service for endpoint " + client.getServerURI());
        this.observedRegistryService = observedRegistryService;
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        this.observedRegistryService.register(deviceAASDescriptor);
        this.sendMqttMessage(TOPIC_REGISTERAAS, deviceAASDescriptor.getIdentifier().getId());
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) throws ProviderException {
        this.observedRegistryService.register(aas, smDescriptor);
        this.sendMqttMessage(TOPIC_REGISTERSUBMODEL, MqttAASRegistryService.concatAasSmId(aas, smDescriptor.getIdentifier()));
    }

    @Override
    public void delete(IIdentifier aasId) throws ProviderException {
        this.observedRegistryService.delete(aasId);
        this.sendMqttMessage(TOPIC_DELETEAAS, aasId.getId());
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        this.observedRegistryService.delete(aasId, smId);
        this.sendMqttMessage(TOPIC_DELETESUBMODEL, MqttAASRegistryService.concatAasSmId(aasId, smId));
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasId) throws ProviderException {
        return this.observedRegistryService.lookupAAS(aasId);
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        return this.observedRegistryService.lookupAll();
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        return this.observedRegistryService.lookupSubmodels(aasId);
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        return this.observedRegistryService.lookupSubmodel(aasId, smId);
    }

    public static String concatAasSmId(IIdentifier aasId, IIdentifier smId) {
        return "(" + aasId.getId() + "," + smId.getId() + ")";
    }
}

