/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IDataElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.relationship.IAnnotatedRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.AnnotatedRelationshipElementValue;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement;

public class AnnotatedRelationshipElement
extends RelationshipElement
implements IAnnotatedRelationshipElement {
    public static final String ANNOTATIONS = "annotation";
    public static final String MODELTYPE = "AnnotatedRelationshipElement";

    public AnnotatedRelationshipElement() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public AnnotatedRelationshipElement(String idShort, IReference first, IReference second) {
        super(idShort, first, second);
        this.putAll(new ModelType(MODELTYPE));
    }

    public void setAnnotation(Collection<IDataElement> annotations) {
        this.put(ANNOTATIONS, annotations);
    }

    private Collection<IDataElement> getAnnotations() {
        ArrayList<IDataElement> list = new ArrayList<IDataElement>();
        Collection annotations = (Collection)this.get(ANNOTATIONS);
        if (annotations == null) {
            return list;
        }
        annotations.stream().map(m -> SubmodelElementFacadeFactory.createSubmodelElement(m)).filter(e -> e instanceof IDataElement).forEach((? super T e) -> list.add((IDataElement)e));
        return list;
    }

    @Override
    public void setValue(Object obj) {
        if (!AnnotatedRelationshipElementValue.isAnnotatedRelationshipElementValue(obj)) {
            throw new IllegalArgumentException("Given Object is not an AnnotatedRelationshipElementValue");
        }
        AnnotatedRelationshipElementValue value = AnnotatedRelationshipElementValue.createAsFacade((Map)obj);
        this.setValue(value);
    }

    public static AnnotatedRelationshipElement createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!AnnotatedRelationshipElement.isValid(obj)) {
            throw new MetamodelConstructionException(AnnotatedRelationshipElement.class, obj);
        }
        AnnotatedRelationshipElement ret = new AnnotatedRelationshipElement();
        ret.setMap(obj);
        return ret;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return RelationshipElement.isValid(obj);
    }

    public static boolean isAnnotatedRelationshipElement(Map<String, Object> value) {
        String modelType = ModelType.createAsFacade(value).getName();
        return MODELTYPE.equals(modelType) || modelType == null && AnnotatedRelationshipElement.isValid(value);
    }

    @Override
    public AnnotatedRelationshipElementValue getValue() {
        return new AnnotatedRelationshipElementValue(this.getFirst(), this.getSecond(), this.getAnnotations());
    }

    @Override
    public void setValue(AnnotatedRelationshipElementValue value) {
        super.setValue(value);
        this.setAnnotation(value.getAnnotations());
    }
}

