/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.restapi.SubmodelElementProvider;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class MultiSubmodelElementProvider
implements IModelProvider {
    public static final String ELEMENTS = "submodelElements";
    public static final String VALUE = "value";
    private IModelProvider modelProvider;

    public MultiSubmodelElementProvider(IModelProvider provider) {
        this.modelProvider = provider;
    }

    protected Collection<Map<String, Object>> getElementsList() {
        Object elements = this.modelProvider.getValue("");
        Map all = (Map)elements;
        return all.entrySet().stream().map(e -> (Map)this.getSingleElement("submodelElements/" + (String)e.getKey())).collect(Collectors.toList());
    }

    private IModelProvider getElementProxy(String[] pathElements) {
        String idShort = pathElements[1];
        return new VABElementProxy(idShort, this.modelProvider);
    }

    private Object getSingleElement(String path) {
        String[] pathElements = VABPathTools.splitPath(path);
        String qualifier = pathElements[0];
        IModelProvider elementProxy = this.getElementProxy(pathElements);
        if (qualifier.equals(ELEMENTS)) {
            String subPath = VABPathTools.buildPath(pathElements, 2);
            return new SubmodelElementProvider(elementProxy).getValue(subPath);
        }
        throw new MalformedRequestException("Given path '" + path + "' does not start with /submodelElements");
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        String[] pathElements = VABPathTools.splitPath(path);
        String qualifier = pathElements[0];
        if (!qualifier.equals(ELEMENTS)) {
            throw new MalformedRequestException("Given path '" + path + "' does not start with /submodelElements");
        }
        if (pathElements.length == 1) {
            return this.getElementsList();
        }
        return this.getSingleElement(path);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        String[] pathElements = VABPathTools.splitPath(path);
        String qualifier = pathElements[0];
        if (pathElements.length < 2 || !qualifier.equals(ELEMENTS)) {
            throw new MalformedRequestException("Given path '" + path + "' is invalid for set");
        }
        IModelProvider elementProxy = this.getElementProxy(pathElements);
        String subPath = VABPathTools.buildPath(pathElements, 2);
        new SubmodelElementProvider(elementProxy).setValue(subPath, newValue);
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        String[] pathElements = VABPathTools.splitPath(path);
        String qualifier = pathElements[0];
        String subPath = VABPathTools.buildPath(pathElements, 2);
        if (!qualifier.equals(ELEMENTS)) {
            throw new MalformedRequestException("Given path '" + path + "' does not start with /submodelElements");
        }
        if (SubmodelElementCollection.isSubmodelElementCollection((Map)newEntity)) {
            SubmodelElementCollection smCollection = SubmodelElementCollection.createAsFacade((Map)newEntity);
            newEntity = SubmodelElementMapCollectionConverter.mapToSmECollection(smCollection);
        }
        if (pathElements.length == 2) {
            try {
                this.modelProvider.setValue(pathElements[1], newEntity);
            }
            catch (ResourceNotFoundException e) {
                this.modelProvider.createValue(pathElements[1], newEntity);
            }
        } else {
            IModelProvider elementProxy = this.getElementProxy(pathElements);
            new SubmodelElementProvider(elementProxy).createValue(subPath, newEntity);
        }
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        String subPath;
        IModelProvider elementProvider;
        String[] pathElements = VABPathTools.splitPath(path);
        String qualifier = pathElements[0];
        if (!qualifier.equals(ELEMENTS)) {
            throw new MalformedRequestException("Given path '" + path + "' does not start with /submodelElements");
        }
        if (pathElements.length > 2) {
            IModelProvider elementProxy = this.getElementProxy(pathElements);
            elementProvider = new SubmodelElementProvider(elementProxy);
            subPath = VABPathTools.buildPath(pathElements, 2);
        } else {
            elementProvider = this.modelProvider;
            subPath = VABPathTools.buildPath(pathElements, 1);
        }
        elementProvider.deleteValue(subPath);
    }

    @Override
    public void deleteValue(String path, Object obj) {
        throw new MalformedRequestException("Delete with a passed argument not allowed");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) throws ProviderException {
        String[] pathElements = VABPathTools.splitPath(path);
        String subPath = VABPathTools.buildPath(pathElements, 2);
        String qualifier = pathElements[0];
        if (!qualifier.equals(ELEMENTS)) {
            throw new MalformedRequestException("Given path '" + path + "' does not start with /submodelElements");
        }
        IModelProvider elementProxy = this.getElementProxy(pathElements);
        return new SubmodelElementProvider(elementProxy).invokeOperation(subPath, parameters);
    }
}

