/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.vab.VABSubmodelAPI;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.lambda.VABLambdaProvider;

public class SubmodelProvider
implements IModelProvider {
    public static final String VALUES = "values";
    public static final String SUBMODEL = "submodel";
    ISubmodelAPI submodelAPI;

    public SubmodelProvider() {
        this(new Submodel());
    }

    public SubmodelProvider(IModelProvider provider) {
        this.submodelAPI = new VABSubmodelAPI(provider);
    }

    public SubmodelProvider(Submodel model) {
        this.submodelAPI = new VABSubmodelAPI(new VABLambdaProvider(model));
    }

    public SubmodelProvider(ISubmodelAPI submodelAPI) {
        this.submodelAPI = submodelAPI;
    }

    private String removeSubmodelPrefix(String path) {
        String submodelWithSlash;
        if ((path = VABPathTools.stripSlashes(path)).startsWith(submodelWithSlash = "submodel/")) {
            path = path.replaceFirst(submodelWithSlash, "");
        } else if (path.equals(SUBMODEL)) {
            path = "";
        } else {
            throw new MalformedRequestException("The request " + path + " is not allowed for this endpoint. /" + SUBMODEL + " is missing");
        }
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        VABPathTools.checkPathForNull(path);
        path = this.removeSubmodelPrefix(path);
        if (path.isEmpty()) {
            ISubmodel sm = this.submodelAPI.getSubmodel();
            if (sm instanceof Submodel) {
                return SubmodelElementMapCollectionConverter.smToMap((Submodel)sm);
            }
            return sm;
        }
        String[] splitted = VABPathTools.splitPath(path);
        if (splitted.length == 1 && splitted[0].equals(VALUES)) {
            return this.submodelAPI.getSubmodel().getValues();
        }
        if (splitted.length == 1 && splitted[0].equals("submodelElements")) {
            return this.submodelAPI.getSubmodelElements();
        }
        if (splitted.length >= 2 && this.isQualifier(splitted[0])) {
            path = this.removeSMElementPrefix(path);
            if (this.endsWithValue(splitted)) {
                String idShortPath = this.removeValueSuffix(path);
                return this.submodelAPI.getSubmodelElementValue(idShortPath);
            }
            if (this.isInvocationListPath(splitted)) {
                List<String> idShorts = this.getIdShorts(splitted);
                idShorts.remove(idShorts.size() - 1);
                idShorts.remove(idShorts.size() - 1);
                return this.submodelAPI.getOperationResult(idShorts.get(0), splitted[splitted.length - 1]);
            }
            return this.submodelAPI.getSubmodelElement(path);
        }
        throw new MalformedRequestException("Unknown path " + path + " was requested");
    }

    private List<String> getIdShorts(String[] splitted) {
        ArrayList<String> idShorts = new ArrayList<String>(Arrays.asList(splitted));
        idShorts.remove(0);
        if (splitted[splitted.length - 1].equals("value")) {
            idShorts.remove(idShorts.size() - 1);
        }
        return idShorts;
    }

    private boolean endsWithValue(String[] splitted) {
        return splitted[splitted.length - 1].equals("value");
    }

    private String removeValueSuffix(String path) {
        String suffix = "/value";
        if (path.endsWith(suffix)) {
            path = path.substring(0, path.length() - suffix.length());
        }
        return path;
    }

    private boolean isInvocationListPath(String[] splitted) {
        return splitted.length > 2 && splitted[splitted.length - 2].equals("invocationList");
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if ((path = this.removeSubmodelPrefix(path)).isEmpty()) {
            throw new MalformedRequestException("Set on \"submodel\" not supported");
        }
        String[] splitted = VABPathTools.splitPath(path);
        path = this.removeSMElementPrefix(path);
        String idshortPath = this.removeValueSuffix(path);
        if (this.endsWithValue(splitted)) {
            this.submodelAPI.updateSubmodelElement(idshortPath, newValue);
        } else {
            SubmodelElement element = SubmodelElement.createAsFacade((Map)newValue);
            if (!path.endsWith(element.getIdShort())) {
                throw new MalformedRequestException("The idShort of given Element '" + element.getIdShort() + "' does not match the ending of the given path '" + path + "'");
            }
            this.submodelAPI.addSubmodelElement(idshortPath, element);
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("POST (create) on '" + path + "' not allowed. Use PUT (set) instead.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteValue(String path) throws ProviderException {
        if ((path = this.removeSubmodelPrefix(path)).isEmpty()) throw new MalformedRequestException("Path \"submodel\" not supported for delete");
        String[] splitted = VABPathTools.splitPath(path);
        if (!this.isQualifier(splitted[0])) throw new MalformedRequestException("Path " + path + " not supported for delete");
        if (splitted.length > 2) {
            path = this.removeSMElementPrefix(path);
            this.submodelAPI.deleteSubmodelElement(path);
            return;
        } else {
            this.submodelAPI.deleteSubmodelElement(splitted[1]);
        }
    }

    private boolean isQualifier(String str) {
        return str.equals("submodelElements");
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete with a passed argument not allowed");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameters) throws ProviderException {
        if ((path = this.removeSubmodelPrefix(path)).isEmpty()) {
            throw new MalformedRequestException("Given path must not be empty");
        }
        if (VABPathTools.isOperationInvokationPath(path)) {
            if (path.endsWith("?async=true")) {
                path = this.removeSMElementPrefix(path);
                path = path.replaceFirst(Pattern.quote("invoke?async=true"), "");
                return this.submodelAPI.invokeAsync(path, parameters);
            }
            path = this.removeSMElementPrefix(path);
            return this.submodelAPI.invokeOperation(path, parameters);
        }
        throw new MalformedRequestException("Given path '" + path + "' does not end in /" + "invoke");
    }

    protected void setAPI(ISubmodelAPI api) {
        this.submodelAPI = api;
    }

    private String removeSMElementPrefix(String path) {
        return path.replaceFirst("submodelElements", "");
    }
}

