/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.submodel.restapi.operation.ExecutionState;
import org.eclipse.basyx.vab.model.VABModelMap;

public class InvocationResponse
extends VABModelMap<Object> {
    public static final String REQUESTID = "requestId";
    public static final String INOUTARGUMENTS = "inoutputArguments";
    public static final String OUTPUTARGUMENTS = "outputArguments";
    public static final String EXECUTIONSTATE = "executionState";

    private InvocationResponse() {
    }

    public InvocationResponse(String requestId, Collection<IOperationVariable> inoutArguments, Collection<IOperationVariable> outputArguments, ExecutionState executionState) {
        this.put(REQUESTID, requestId);
        this.put(INOUTARGUMENTS, inoutArguments);
        this.put(OUTPUTARGUMENTS, outputArguments);
        this.put(EXECUTIONSTATE, executionState.toString());
    }

    public static InvocationResponse createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        InvocationResponse resp = new InvocationResponse();
        resp.setRequestId((String)map.get(REQUESTID));
        Collection<IOperationVariable> inoutArguments = InvocationResponse.createInoutArguments(map);
        resp.setInOutArguments(inoutArguments);
        Collection<IOperationVariable> outputArguments = InvocationResponse.createOutputArguments(map);
        resp.setOutputArguments(outputArguments);
        Object execStateObj = map.get(EXECUTIONSTATE);
        if (execStateObj instanceof String) {
            resp.setExecutionState(ExecutionState.fromString((String)execStateObj));
        } else if (execStateObj instanceof ExecutionState) {
            resp.setExecutionState((ExecutionState)execStateObj);
        }
        return resp;
    }

    private static Collection<IOperationVariable> createOutputArguments(Map<String, Object> map) {
        Collection outputMap = (Collection)map.get(OUTPUTARGUMENTS);
        return InvocationResponse.createOperationVariables(outputMap);
    }

    private static Collection<IOperationVariable> createInoutArguments(Map<String, Object> map) {
        Collection inoutMap = (Collection)map.get(INOUTARGUMENTS);
        return InvocationResponse.createOperationVariables(inoutMap);
    }

    private static Collection<IOperationVariable> createOperationVariables(Collection<Map<String, Object>> variableMap) {
        if (variableMap != null) {
            return variableMap.stream().map(OperationVariable::createAsFacade).collect(Collectors.toList());
        }
        return new ArrayList<IOperationVariable>();
    }

    public Object getFirstOutput() {
        try {
            IOperationVariable next = this.getOutputArguments().iterator().next();
            return next.getValue().getValue();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private void setRequestId(String request) {
        this.put(REQUESTID, request);
    }

    private void setInOutArguments(Collection<IOperationVariable> inoutArguments) {
        this.put(INOUTARGUMENTS, inoutArguments);
    }

    private void setOutputArguments(Collection<IOperationVariable> inputArguments) {
        this.put(OUTPUTARGUMENTS, inputArguments);
    }

    public void setExecutionState(ExecutionState state) {
        this.put(EXECUTIONSTATE, state.toString());
    }

    public String getRequestId() {
        return (String)this.get(REQUESTID);
    }

    public Collection<IOperationVariable> getInOutArguments() {
        return (Collection)this.get(INOUTARGUMENTS);
    }

    public Collection<IOperationVariable> getOutputArguments() {
        return (Collection)this.get(OUTPUTARGUMENTS);
    }

    public ExecutionState getExecutionState() {
        return ExecutionState.fromString((String)this.get(EXECUTIONSTATE));
    }
}

