/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.connector;

import io.netty.handler.codec.http.HttpMethod;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.eclipse.basyx.vab.protocol.http.server.ExceptionToHTTPCodeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPConnector
implements IBaSyxConnector {
    private static Logger logger = LoggerFactory.getLogger(HTTPConnector.class);
    private String address;
    private String mediaType;
    protected Client client;

    @Override
    public String getValue(String servicePath) {
        return this.httpGet(servicePath);
    }

    public HTTPConnector(String address) {
        this(address, "application/json;charset=UTF-8");
    }

    public HTTPConnector(String address, String mediaType) {
        this.address = address;
        this.mediaType = mediaType;
        this.client = ClientBuilder.newClient();
        logger.trace("Create with addr: {}", (Object)address);
    }

    @Override
    public String setValue(String servicePath, String newValue) throws ProviderException {
        return this.httpPut(servicePath, newValue);
    }

    @Override
    public String deleteValue(String servicePath, String obj) throws ProviderException {
        return this.httpPatch(servicePath, obj);
    }

    @Override
    public String createValue(String servicePath, String newValue) throws ProviderException {
        return this.httpPost(servicePath, newValue);
    }

    @Override
    public String deleteValue(String servicePath) throws ProviderException {
        return this.httpDelete(servicePath);
    }

    protected Invocation.Builder buildRequest(Client client, String wsURL) {
        WebTarget resource = client.target(wsURL);
        Invocation.Builder request = resource.request();
        request.accept(new String[]{this.mediaType});
        return request;
    }

    protected String createWSPath(String part1, String part2) {
        if (part1 == null) {
            return part2;
        }
        if (part2 == null) {
            return part1;
        }
        if (part1.endsWith("/")) {
            return part1 + part2;
        }
        return part1 + "/" + part2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpGet(String servicePath) throws ProviderException {
        logger.trace("[HTTP Get] {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath));
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.get();
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.GET, this.getStatusCode(rsp));
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPut(String servicePath, String newValue) throws ProviderException {
        logger.trace("[HTTP Put] {} [[ {} ]]", (Object)VABPathTools.concatenatePaths(this.address, servicePath), (Object)newValue);
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.put(Entity.entity((Object)newValue, (String)this.mediaType));
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.PUT, this.getStatusCode(rsp));
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String httpPatch(String servicePath, String newValue) throws ProviderException {
        logger.trace("[HTTP Patch] {} {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath), (Object)newValue);
        Response rsp = null;
        try {
            rsp = this.client.target(VABPathTools.concatenatePaths(this.address, servicePath)).request().build("PATCH", Entity.text((Object)newValue)).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).invoke();
            if (this.isRequestSuccess(rsp)) return (String)rsp.readEntity(String.class);
        }
        catch (Throwable throwable) {
            if (this.isRequestSuccess(rsp)) throw throwable;
            throw this.handleProcessingException(HttpMethod.PATCH, this.getStatusCode(rsp));
        }
        throw this.handleProcessingException(HttpMethod.PATCH, this.getStatusCode(rsp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPost(String servicePath, String parameter) throws ProviderException {
        logger.trace("[HTTP Post] {} {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath), (Object)parameter);
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.post(Entity.entity((Object)parameter, (String)this.mediaType));
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.POST, this.getStatusCode(rsp));
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpDelete(String servicePath) throws ProviderException {
        logger.trace("[HTTP Delete] {}", (Object)VABPathTools.concatenatePaths(this.address, servicePath));
        Invocation.Builder request = this.retrieveBuilder(servicePath);
        Response rsp = null;
        try {
            rsp = request.delete();
        }
        finally {
            if (!this.isRequestSuccess(rsp)) {
                throw this.handleProcessingException(HttpMethod.DELETE, this.getStatusCode(rsp));
            }
        }
        return (String)rsp.readEntity(String.class);
    }

    @Override
    public String invokeOperation(String path, String parameter) throws ProviderException {
        return this.httpPost(path, parameter);
    }

    private Invocation.Builder retrieveBuilder(String servicePath) {
        return this.buildRequest(this.client, VABPathTools.concatenatePaths(this.address, servicePath));
    }

    private ProviderException handleProcessingException(HttpMethod method, int statusCode) {
        if (statusCode == 0) {
            return ExceptionToHTTPCodeMapper.mapToException(404, "[HTTP " + method.name() + "] Failed to request " + this.address + " with mediatype " + this.mediaType);
        }
        return ExceptionToHTTPCodeMapper.mapToException(statusCode, "[HTTP " + method.name() + "] Failed to request " + this.address + " with mediatype " + this.mediaType);
    }

    private int getStatusCode(Response rsp) {
        return rsp != null ? rsp.getStatus() : 0;
    }

    private boolean isRequestSuccess(Response rsp) {
        return rsp != null && rsp.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL;
    }

    @Override
    public String getEndpointRepresentation(String path) {
        return VABPathTools.concatenatePaths(this.address, path);
    }
}

