/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.basyx.AasxPersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractBaSyxAasFactory;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxAbstractAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistry;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRegistryDeploymentAasServer;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.VersionAdjustment;
import de.iip_ecosphere.platform.support.aas.basyx.basyx.BaSyxHTTPServer;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.basyx.components.aas.configuration.AASServerBackend;
import org.eclipse.basyx.components.aas.configuration.BaSyxAASServerConfiguration;
import org.eclipse.basyx.submodel.metamodel.connected.submodelelement.operation.ConnectedOperation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IBaSyxConnector;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.IAuthorizationSupplier;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;
import org.eclipse.basyx.vab.protocol.https.HTTPSConnectorProvider;

public class BaSyxAasFactory
extends AbstractBaSyxAasFactory {
    static final boolean ENABLE_PROPERTY_LAMBDA = true;
    private static final String PLUGIN_ID = "aas.basyx-1.3";

    public BaSyxAasFactory() {
        this.registerProtocolCreator("VAB-HTTPS", new AbstractBaSyxAasFactory.VabHttpsProtocolCreator());
        this.registerPersistenceRecipe(new AasxPersistenceRecipe());
        VersionAdjustment.registerSetPropertyKind(Property.class, (p, k) -> p.setKind(k));
        VersionAdjustment.registerOperationInvoke(Operation.class, (o, a) -> o.invokeSimple(a));
        VersionAdjustment.registerOperationInvoke(ConnectedOperation.class, (o, a) -> o.invokeSimple(a));
        VersionAdjustment.registerSetBearerTokenAuthenticationConfiguration(BaSyxContext.class, (c, i, j, r) -> c.setJwtBearerTokenAuthenticationConfiguration(JwtBearerTokenAuthenticationConfiguration.of((String)i, (String)j, (String)r)));
        VersionAdjustment.registerSetupBaSyxAASServerConfiguration(BaSyxAASServerConfiguration.class, c -> BaSyxAasFactory.setup(c));
        VersionAdjustment.setupBaSyxServerCreator(new VersionAdjustment.ServerCreator(){

            @Override
            public Server createServer(DeploymentSpec dSpec, SetupSpec sSpec, SetupSpec.AasComponent component) {
                final BaSyxHTTPServer server = new BaSyxHTTPServer(dSpec.getContext(), sSpec, component);
                Server result = new Server(){

                    public Server start() {
                        server.start();
                        return this;
                    }

                    public void stop(boolean dispose) {
                        server.shutdown();
                    }
                };
                return result;
            }
        });
        VersionAdjustment.setupRegistryDeploymentServerCreator(new VersionAdjustment.RegistryDeploymentServerCreator(){

            @Override
            public BaSyxAbstractAasServer createRegistryDeploymentServer(DeploymentSpec deploymentSpec, SetupSpec spec, SetupSpec.AasComponent component, String regUrl, AASServerBackend backend, String ... options) {
                return new BaSyxRegistryDeploymentAasServer(deploymentSpec, spec, component, regUrl, backend, options);
            }
        });
    }

    private static void setup(BaSyxAASServerConfiguration cfg) {
        cfg.disablePropertyDelegation();
    }

    public boolean supportsPropertyFunctions() {
        return true;
    }

    public String getName() {
        return "AAS/BaSyx v1.3.0 (2022/12/15)";
    }

    @Override
    public Registry obtainRegistry(SetupSpec spec, Schema aasSchema) throws IOException {
        SetupSpec.ComponentSetup cSetup = spec.getSetup(SetupSpec.AasComponent.AAS_REGISTRY);
        final AuthenticationDescriptor aDesc = cSetup.getAuthentication();
        final IAuthorizationSupplier authSupplier = new IAuthorizationSupplier(){

            public Optional<String> getAuthorization() {
                String header = null;
                if (AuthenticationDescriptor.isEnabledOnClient((AuthenticationDescriptor)aDesc)) {
                    header = AuthenticationDescriptor.authenticate((AuthenticationDescriptor)aDesc, (boolean)false);
                }
                return header == null ? Optional.empty() : Optional.of(header);
            }
        };
        Object cFactory = Schema.HTTPS == aasSchema ? new HTTPSConnectorProvider(authSupplier) : new HTTPConnectorFactory(){

            protected IModelProvider createProvider(String addr) {
                return new JSONConnector((IBaSyxConnector)new HTTPConnector(addr, authSupplier));
            }
        };
        return new BaSyxRegistry(cSetup.getEndpoint(), (IConnectorFactory)cFactory);
    }

    public static class Descriptor
    extends AasFactory.AbstractDescriptor {
        public AasFactory createInstance() {
            return new BaSyxAasFactory();
        }

        public String getId() {
            return "aas-default";
        }

        public List<String> getFurtherIds() {
            return List.of(BaSyxAasFactory.PLUGIN_ID);
        }
    }
}

