/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxVABTCPPayloadCodec;
import de.iip_ecosphere.platform.support.aas.basyx.DeploymentSpec;
import de.iip_ecosphere.platform.support.aas.basyx.VersionAdjustment;
import de.iip_ecosphere.platform.support.aas.basyx.basyx.BaSyxTCPServer;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServlet;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.modelprovider.generic.IVABElementHandler;
import org.eclipse.basyx.vab.modelprovider.generic.VABModelProvider;
import org.eclipse.basyx.vab.protocol.http.server.VABHTTPInterface;

public class VabOperationsProvider
extends HashMap<String, Object>
implements OperationsProvider {
    public static final String SEPARATOR = "/";
    public static final String STATUS = "status";
    public static final String PREFIX_STATUS = "status/";
    public static final String OPERATIONS = "operations";
    public static final String PREFIX_OPERATIONS = "operations/";
    public static final String SERVICE = "service";
    public static final String PREFIX_SERVICE = "operations/service/";
    private static final long serialVersionUID = 6355197555283292724L;
    private Map<String, Entry> status = new HashMap<String, Entry>();
    private Map<String, Map<String, Entry>> operations = new HashMap<String, Map<String, Entry>>();
    private Map<String, Entry> service = new HashMap<String, Entry>();
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Map<String, Function<Object[], Object>> operationFunctions = new HashMap<String, Function<Object[], Object>>();
    private OperationsProvider.Interceptor interceptor;

    public VabOperationsProvider() {
        this.put(this.getStatusPath(), this.status);
        this.put(this.getOperationsPath(), this.operations);
        this.operations.put(this.getServicePath(), this.service);
    }

    protected String getStatusPath() {
        return STATUS;
    }

    protected String getOperationsPath() {
        return OPERATIONS;
    }

    protected String getServicePath() {
        return SERVICE;
    }

    public VABModelProvider createModelProvider() {
        return new VABModelProvider((Object)this, (IVABElementHandler)new VABElementHandler());
    }

    private String makeUnique(Map<String, ?> map, String baseName) {
        Object uName = baseName;
        int pos = 1;
        while (this.operationFunctions.containsKey(uName)) {
            uName = baseName + "_" + pos;
            ++pos;
        }
        return uName;
    }

    public VabOperationsProvider defineOperation(String category, String name, Function<Object[], Object> function) {
        String uName = this.makeUnique(this.operationFunctions, category + SEPARATOR + name);
        Map<String, Entry> o = this.operations.get(category);
        if (null == o) {
            o = new HashMap<String, Entry>();
            this.operations.put(category, o);
        }
        o.put(name, new Entry(Kind.OPERATION, uName));
        this.operationFunctions.put(uName, function);
        LoggerFactory.getLogger(this.getClass()).info("Operation " + category + SEPARATOR + name + " defined (uname " + uName + ")");
        return this;
    }

    public Function<Object[], Object> getOperation(String category, String name) {
        Entry ent;
        Function<Object[], Object> result = null;
        Map<String, Entry> cat = this.operations.get(category);
        if (null != cat && (ent = cat.get(name)) != null && Kind.OPERATION == ent.kind) {
            result = this.operationFunctions.get(ent.uName);
        }
        if (this.interceptor != null) {
            result = this.interceptor.getOperation(category, name, result);
        }
        return result;
    }

    public Function<Object[], Object> getServiceFunction(String name) {
        return this.getOperation(this.getServicePath(), name);
    }

    public Set<String> getOperations(boolean qualified) {
        HashSet<String> result = new HashSet<String>();
        for (String category : this.operations.keySet()) {
            this.addOperations(category, qualified, result);
        }
        return result;
    }

    public Set<String> getOperations(String category, boolean qualified) {
        return this.addOperations(category, qualified, new HashSet<String>());
    }

    private Set<String> addOperations(String category, boolean qualified, Set<String> result) {
        Map<String, Entry> cat = this.operations.get(category);
        if (null != cat) {
            Object prefix = qualified ? PREFIX_OPERATIONS + category + SEPARATOR : "";
            cat.keySet().forEach(arg_0 -> VabOperationsProvider.lambda$addOperations$0(result, (String)prefix, arg_0));
        }
        return result;
    }

    public Set<String> getServiceOperations(boolean qualified) {
        return this.getOperations(this.getServicePath(), qualified);
    }

    public VabOperationsProvider defineServiceFunction(String name, Function<Object[], Object> function) {
        return this.defineOperation(this.getServicePath(), name, (Function)function);
    }

    public VabOperationsProvider defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
        this.properties.put(name, new Property(get, set));
        this.status.put(name, new Entry(Kind.PROPERTY, name));
        LoggerFactory.getLogger(this.getClass()).info("Property " + name + " defined");
        return this;
    }

    public Supplier<Object> getGetter(String name) {
        Supplier result;
        Property prop = this.properties.get(name);
        Supplier supplier = result = null == prop ? null : prop.get;
        if (this.interceptor != null) {
            result = this.interceptor.getGetter(name, result);
        }
        return result;
    }

    public Consumer<Object> getSetter(String name) {
        Consumer result;
        Property prop = this.properties.get(name);
        Consumer consumer = result = null == prop ? null : prop.set;
        if (this.interceptor != null) {
            result = this.interceptor.getSetter(name, result);
        }
        return result;
    }

    public void setInterceptor(OperationsProvider.Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    private static /* synthetic */ void lambda$addOperations$0(Set result, String prefix, String k) {
        result.add(prefix + k);
    }

    private class VABElementHandler
    implements IVABElementHandler {
        private VABElementHandler() {
        }

        public Object postprocessObject(Object element) {
            Object result = element;
            if (element instanceof Property) {
                result = ((Property)element).get.get();
            }
            return result;
        }

        public Object getElementProperty(Object element, String propertyName) {
            Map map = (Map)element;
            Object result = map.get(propertyName);
            if (result instanceof Entry) {
                Entry entry = (Entry)result;
                switch (entry.kind.ordinal()) {
                    case 0: {
                        result = VabOperationsProvider.this.properties.get(entry.uName);
                        break;
                    }
                    case 1: {
                        result = VabOperationsProvider.this.operationFunctions.get(entry.uName);
                        break;
                    }
                    default: {
                        throw new ResourceNotFoundException("Unkown entry kind for " + propertyName);
                    }
                }
                if (null == result) {
                    throw new ResourceNotFoundException(entry.kind.name().toLowerCase() + propertyName + " not found.");
                }
            }
            return result;
        }

        public void setModelPropertyValue(Object element, String propertyName, Object newValue) {
            Property prop = VabOperationsProvider.this.properties.get(propertyName);
            if (null == prop) {
                throw new ResourceNotFoundException("Property " + propertyName + " not found.");
            }
            if (null == prop.set) {
                throw new ResourceNotFoundException("Property " + propertyName + " not found (for reading).");
            }
            prop.set.accept(newValue);
        }

        public void createValue(Object element, Object newValue) {
            throw new ResourceNotFoundException("Element " + String.valueOf(element) + " not supported.");
        }

        public void deleteValue(Object element, String propertyName) {
            throw new ResourceNotFoundException("Element " + String.valueOf(element) + " not supported.");
        }

        public void deleteValue(Object element, Object property) {
            throw new ResourceNotFoundException("Element " + String.valueOf(element) + " not found.");
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 3003478232778729891L;
        private Kind kind;
        private String uName;

        private Entry(Kind kind, String uName) {
            this.kind = kind;
            this.uName = uName;
        }
    }

    private static enum Kind {
        PROPERTY,
        OPERATION;

    }

    private static class Property {
        private Consumer<Object> set;
        private Supplier<Object> get;

        private Property(Supplier<Object> get, Consumer<Object> set) {
            this.set = set;
            this.get = get;
        }
    }

    static class VabHttpOperationsBuilder
    implements ProtocolServerBuilder {
        private SetupSpec setup;
        private SetupSpec.AasComponent component;
        private int port;
        private Schema schema;
        private VabOperationsProvider instance;
        private KeyStoreDescriptor kstore;

        VabHttpOperationsBuilder(SetupSpec setup, SetupSpec.AasComponent component, Schema schema) {
            this.setup = setup;
            this.component = component;
            SetupSpec.ComponentSetup cSetup = setup.getSetup(component);
            this.port = cSetup.getServerAddress().getPort();
            this.instance = new VabOperationsProvider();
            this.kstore = schema == Schema.HTTPS ? cSetup.getKeyStore() : null;
        }

        public ProtocolServerBuilder defineOperation(String name, Function<Object[], Object> function) {
            this.instance.defineServiceFunction(name, (Function)function);
            return this;
        }

        public ProtocolServerBuilder defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
            this.instance.defineProperty(name, (Supplier)get, (Consumer)set);
            return this;
        }

        public Server build() {
            Endpoint endpoint = new Endpoint(this.schema, this.port, "");
            VABHTTPInterface vabServlet = new VABHTTPInterface((IModelProvider)this.instance.createModelProvider());
            DeploymentSpec deploymentSpec = new DeploymentSpec(endpoint, this.kstore);
            deploymentSpec.getContext().addServletMapping(Endpoint.checkEndpoint((String)endpoint.getEndpoint()) + "/*", (HttpServlet)vabServlet);
            return VersionAdjustment.createBaSyxServer(deploymentSpec, this.setup, this.component);
        }

        public ProtocolServerBuilder.PayloadCodec createPayloadCodec() {
            return new BaSyxVABTCPPayloadCodec();
        }

        public boolean isAvailable(String host) {
            return NetUtils.isAvailable((String)host, (int)this.port);
        }

        public void setInterceptor(OperationsProvider.Interceptor interceptor) {
            this.instance.setInterceptor(interceptor);
        }
    }

    static class VabTcpOperationsBuilder
    implements ProtocolServerBuilder {
        private int port;
        private VabOperationsProvider instance;

        VabTcpOperationsBuilder(int port) {
            this.port = port;
            this.instance = new VabOperationsProvider();
        }

        public VabTcpOperationsBuilder defineOperation(String name, Function<Object[], Object> function) {
            this.instance.defineServiceFunction(name, (Function)function);
            return this;
        }

        public VabTcpOperationsBuilder defineProperty(String name, Supplier<Object> get, Consumer<Object> set) {
            this.instance.defineProperty(name, (Supplier)get, (Consumer)set);
            return this;
        }

        public Server build() {
            System.out.println("Starting VAB server on " + this.port);
            final BaSyxTCPServer<VABModelProvider> server = new BaSyxTCPServer<VABModelProvider>(this.instance.createModelProvider(), this.port);
            Server result = new Server(){

                public Server start() {
                    server.start();
                    return this;
                }

                public void stop(boolean dispose) {
                    server.stop();
                }
            };
            return result;
        }

        public ProtocolServerBuilder.PayloadCodec createPayloadCodec() {
            return new BaSyxVABTCPPayloadCodec();
        }

        public boolean isAvailable(String host) {
            return NetUtils.isAvailable((String)host, (int)this.port);
        }

        public void setInterceptor(OperationsProvider.Interceptor interceptor) {
            this.instance.setInterceptor(interceptor);
        }
    }
}

