/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.metamodel.map.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.model.VABModelMap;

public abstract class ModelDescriptor
extends VABModelMap<Object> {
    public static final String ENDPOINTS = "endpoints";

    protected ModelDescriptor() {
        this.putAll(new ModelType(this.getModelType()));
    }

    public ModelDescriptor(Map<String, Object> map) {
        this();
        this.putAll(map);
    }

    public ModelDescriptor(String idShort, IIdentifier id, String httpEndpoint) {
        this();
        this.put("idShort", idShort);
        Identifier identifierMap = new Identifier(id.getIdType(), id.getId());
        this.put("identification", identifierMap);
        HashMap<String, String> endpointWrapper = new HashMap<String, String>();
        endpointWrapper.put("type", "http");
        endpointWrapper.put("address", httpEndpoint);
        this.put(ENDPOINTS, Arrays.asList(endpointWrapper));
    }

    public IIdentifier getIdentifier() {
        Map identifierModel = (Map)this.get("identification");
        return Identifier.createAsFacade(identifierModel);
    }

    public String getIdShort() {
        return Referable.createAsFacade(this, null).getIdShort();
    }

    public String getFirstEndpoint() {
        Object e = this.get(ENDPOINTS);
        if (e instanceof Collection) {
            Collection endpoints = (Collection)e;
            if (endpoints.isEmpty()) {
                return "";
            }
            return (String)((Map)endpoints.iterator().next()).get("address");
        }
        return "";
    }

    public Collection<Map<String, Object>> getEndpoints() {
        Object endpoints = this.get(ENDPOINTS);
        if (endpoints instanceof Collection) {
            return (Collection)endpoints;
        }
        return new ArrayList<Map<String, Object>>();
    }

    protected void validate(Map<String, Object> map) {
        if (!map.containsKey("idShort") || !(map.get("idShort") instanceof String)) {
            throw new MalformedRequestException(this.getModelType() + " is missing idShort entry");
        }
        if (!map.containsKey("identification") || !(map.get("identification") instanceof Map)) {
            throw new MalformedRequestException(this.getModelType() + " is missing identification entry");
        }
        if (!map.containsKey(ENDPOINTS) || !(map.get(ENDPOINTS) instanceof Collection)) {
            throw new MalformedRequestException(this.getModelType() + " is missing endpoints entry");
        }
    }

    protected abstract String getModelType();
}

