/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.registry.proxy.VABRegistryProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AASRegistryProxy
extends VABRegistryProxy
implements IAASRegistry {
    private static Logger logger = LoggerFactory.getLogger(AASRegistryProxy.class);

    public AASRegistryProxy(String registryUrl) {
        this(new JSONConnector(new HTTPConnector(AASRegistryProxy.harmonizeURL(registryUrl))));
    }

    private static String harmonizeURL(String url) {
        if (url.endsWith("api/v1/registry")) {
            url = url.substring(0, url.length() - "api/v1/registry".length());
        }
        return url;
    }

    public AASRegistryProxy(IModelProvider provider) throws ProviderException {
        super(AASRegistryProxy.createProxy(provider));
    }

    private static VABElementProxy createProxy(IModelProvider provider) {
        return new VABElementProxy("api/v1/registry", provider);
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        try {
            String encodedId = VABPathTools.encodePathElement(deviceAASDescriptor.getIdentifier().getId());
            this.provider.setValue(encodedId, deviceAASDescriptor);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public void delete(IIdentifier aasIdentifier) throws ProviderException {
        try {
            this.removeMapping(URLEncoder.encode(aasIdentifier.getId(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Could not encode URL. This should not happen");
            throw new RuntimeException(e);
        }
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasIdentifier) throws ProviderException {
        try {
            Object result = this.provider.getValue(URLEncoder.encode(aasIdentifier.getId(), "UTF-8"));
            return new AASDescriptor((Map)result);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        try {
            Object result = this.provider.getValue("");
            Collection descriptors = (Collection)result;
            return descriptors.stream().map(x -> new AASDescriptor((Map)x)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) throws ProviderException {
        try {
            this.provider.setValue(VABPathTools.concatenatePaths(this.buildSubmodelPath(aas), URLEncoder.encode(smDescriptor.getIdentifier().getId(), "UTF-8")), smDescriptor);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        try {
            this.provider.deleteValue(VABPathTools.concatenatePaths(this.buildSubmodelPath(aasId), URLEncoder.encode(smId.getId(), "UTF-8")));
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    private String buildSubmodelPath(IIdentifier aas) throws ProviderException {
        String encodedAASId = VABPathTools.encodePathElement(aas.getId());
        return VABPathTools.concatenatePaths(encodedAASId, "submodels");
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        try {
            Object result = this.provider.getValue(VABPathTools.concatenatePaths(this.buildSubmodelPath(aasId)));
            Collection descriptors = (Collection)result;
            return descriptors.stream().map(x -> new SubmodelDescriptor((Map)x)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        try {
            Object result = this.provider.getValue(VABPathTools.concatenatePaths(this.buildSubmodelPath(aasId), URLEncoder.encode(smId.getId(), "UTF-8")));
            return new SubmodelDescriptor((Map)result);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }
}

