/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IDataElement;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.Blob;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.ReferenceElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.Range;

public class DataElement
extends SubmodelElement
implements IDataElement {
    public static final String MODELTYPE = "DataElement";

    public DataElement() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public DataElement(String idShort) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
    }

    public static DataElement createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!DataElement.isValid(obj)) {
            throw new MetamodelConstructionException(DataElement.class, obj);
        }
        DataElement facade = new DataElement();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj);
    }

    public static boolean isDataElement(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || Property.isProperty(map) || Blob.isBlob(map) || File.isFile(map) || Range.isRange(map) || MultiLanguageProperty.isMultiLanguageProperty(map) || ReferenceElement.isReferenceElement(map);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.DATAELEMENT;
    }

    @Override
    public DataElement getLocalCopy() {
        DataElement copy = new DataElement();
        copy.putAll(this);
        return copy;
    }
}

