/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.modelprovider.consistency;

import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class ConsistencyProvider<T extends IModelProvider>
implements IModelProvider {
    protected T providerBackend = null;
    protected Integer clock = 0;
    private boolean frozen = false;

    public ConsistencyProvider(T modelProviderBackend) {
        this.providerBackend = modelProviderBackend;
    }

    public T getBackendReference() {
        return this.providerBackend;
    }

    private void incrementClock() {
        this.clock = this.clock + 1;
    }

    private boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if (path.endsWith("/frozen")) {
            return this.frozen;
        }
        if (path.endsWith("/clock")) {
            return this.clock;
        }
        return this.providerBackend.getValue(path);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if (path.endsWith("/frozen")) {
            this.frozen = (Boolean)newValue;
        } else if (!this.frozen) {
            this.incrementClock();
            this.providerBackend.setValue(path, newValue);
        } else {
            throw new ProviderException("Value " + path + " is read only");
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if (!this.isFrozen() || path.endsWith("/frozen")) {
            this.providerBackend.createValue(path, newEntity);
        }
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        if (!this.isFrozen() || path.endsWith("/frozen")) {
            this.providerBackend.deleteValue(path);
        }
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        if (this.isFrozen() && !path.endsWith("/frozen")) {
            throw new ProviderException("Value " + path + " is read only");
        }
        this.incrementClock();
        this.providerBackend.deleteValue(path, obj);
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        return this.providerBackend.invokeOperation(path, parameter);
    }
}

