/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.qualifier;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangString;

public class LangStrings
extends HashSet<LangString> {
    private static final long serialVersionUID = 1L;

    public LangStrings() {
    }

    public LangStrings(String language, String description) {
        this.add(new LangString(language, description));
    }

    public LangStrings(LangString langString) {
        this.add(langString);
    }

    public LangStrings(Collection<LangString> langStrings) {
        if (langStrings != null) {
            langStrings.stream().forEach(ls -> this.add(ls));
        }
    }

    public static LangStrings createAsFacade(Collection<Map<String, Object>> maps) {
        if (maps == null) {
            return null;
        }
        LangStrings ret = new LangStrings();
        for (Map<String, Object> map : maps) {
            LangString langString = LangString.createAsFacade(map);
            ret.add(langString);
        }
        return ret;
    }

    public static boolean isLangStrings(Object value) {
        if (!(value instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)value;
        return collection.stream().allMatch(LangString::isLangString);
    }

    public String get(String language) {
        for (LangString langString : this) {
            String currLanguage = langString.getLanguage();
            if (!(currLanguage == null ? language == null : currLanguage.equalsIgnoreCase(language))) continue;
            return langString.getDescription();
        }
        return "";
    }

    public Set<String> getLanguages() {
        HashSet<String> languageSet = new HashSet<String>();
        for (LangString langString : this) {
            languageSet.add(langString.getLanguage());
        }
        return languageSet;
    }
}

