/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi;

import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.restapi.SubmodelElementProvider;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class SubmodelElementCollectionProvider
implements IModelProvider {
    private IModelProvider proxy;

    public SubmodelElementCollectionProvider(IModelProvider proxy) {
        this.proxy = proxy;
    }

    protected IModelProvider getElementProvider(String idShort) {
        VABElementProxy defaultProvider = new VABElementProxy(VABPathTools.concatenatePaths("value", idShort), this.proxy);
        return new SubmodelElementProvider(defaultProvider);
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        if (path.isEmpty()) {
            Map map = (Map)this.proxy.getValue(path);
            SubmodelElementCollection smElemColl = SubmodelElementCollection.createAsFacade(map);
            return SubmodelElementMapCollectionConverter.smElementToMap(smElemColl);
        }
        if (path.equals("value")) {
            return SubmodelElementMapCollectionConverter.convertIDMapToCollection(this.proxy.getValue(path));
        }
        String idShort = pathElements[0];
        String subPath = VABPathTools.buildPath(pathElements, 1);
        return this.getElementProvider(idShort).getValue(subPath);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        if (path.isEmpty()) {
            SubmodelElementCollection value = SubmodelElementMapCollectionConverter.mapToSmECollection((Map)newValue);
            this.proxy.setValue(path, value);
        } else if (path.equals("value")) {
            Map<String, Object> value = SubmodelElementMapCollectionConverter.convertCollectionToIDMap(newValue);
            this.proxy.setValue(path, value);
        } else {
            String idShort = pathElements[0];
            String subPath = VABPathTools.buildPath(pathElements, 1);
            this.getElementProvider(idShort).setValue(subPath, newValue);
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        String[] pathElements = VABPathTools.splitPath(path = VABPathTools.stripSlashes(path));
        if (pathElements.length == 1) {
            String valuePath = VABPathTools.concatenatePaths("value", path);
            try {
                this.proxy.setValue(valuePath, newEntity);
            }
            catch (ResourceNotFoundException e) {
                this.proxy.createValue(valuePath, newEntity);
            }
        } else {
            String idShort = pathElements[0];
            String subPath = VABPathTools.buildPath(pathElements, 1);
            this.getElementProvider(idShort).createValue(subPath, newEntity);
        }
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        if (path.isEmpty() || path.equals("value")) {
            throw new MalformedRequestException("Path must not be empty or /value");
        }
        if (pathElements.length == 1) {
            this.proxy.deleteValue(VABPathTools.concatenatePaths("value", path));
        } else {
            String idShort = pathElements[0];
            String subPath = VABPathTools.buildPath(pathElements, 1);
            this.getElementProvider(idShort).deleteValue(subPath);
        }
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("Delete with a passed argument not allowed");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        path = VABPathTools.stripSlashes(path);
        String[] pathElements = VABPathTools.splitPath(path);
        if (path.isEmpty() || path.equals("value")) {
            throw new MalformedRequestException("Path must not be empty or /value");
        }
        String idShort = pathElements[0];
        String subPath = VABPathTools.buildPath(pathElements, 1);
        return this.getElementProvider(idShort).invokeOperation(subPath, parameter);
    }
}

