/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.restapi.vab;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.restapi.MultiSubmodelElementProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class VABSubmodelAPI
implements ISubmodelAPI {
    private IModelProvider modelProvider;

    public VABSubmodelAPI(IModelProvider modelProvider) {
        this.modelProvider = modelProvider;
    }

    private MultiSubmodelElementProvider getElementProvider() {
        VABElementProxy elementProxy = new VABElementProxy("submodelElements", this.modelProvider);
        return new MultiSubmodelElementProvider(elementProxy);
    }

    @Override
    public ISubmodel getSubmodel() {
        Map map = (Map)this.modelProvider.getValue("");
        HashMap<String, Object> smCopy = new HashMap<String, Object>();
        smCopy.putAll(map);
        return Submodel.createAsFacade(smCopy);
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        this.getElementProvider().createValue("submodelElements/" + elem.getIdShort(), elem);
    }

    @Override
    public void addSubmodelElement(String idShortPath, ISubmodelElement elem) {
        this.getElementProvider().createValue("submodelElements/" + idShortPath, elem);
    }

    @Override
    public void deleteSubmodelElement(String idShortPath) {
        this.getElementProvider().deleteValue("submodelElements/" + idShortPath);
    }

    @Override
    public Collection<IOperation> getOperations() {
        return this.getSubmodelElements().stream().filter(e -> e instanceof IOperation).map(e -> (IOperation)e).collect(Collectors.toList());
    }

    @Override
    public Collection<ISubmodelElement> getSubmodelElements() {
        Collection elements = (Collection)this.getElementProvider().getValue("submodelElements");
        return elements.stream().map(SubmodelElement::createAsFacade).collect(Collectors.toList());
    }

    @Override
    public void updateSubmodelElement(String idShortPath, Object newValue) {
        this.getElementProvider().setValue(this.buildValuePathForProperty(idShortPath), newValue);
    }

    @Override
    public Object getSubmodelElementValue(String idShortPath) {
        return this.getElementProvider().getValue(this.buildValuePathForProperty(idShortPath));
    }

    @Override
    public ISubmodelElement getSubmodelElement(String idShortPath) {
        return SubmodelElement.createAsFacade((Map)this.getElementProvider().getValue("submodelElements/" + idShortPath));
    }

    @Override
    public Object invokeOperation(String idShortPath, Object ... params) {
        return this.getElementProvider().invokeOperation("submodelElements/" + idShortPath, params);
    }

    @Override
    public Object invokeAsync(String idShortPath, Object ... params) {
        return this.getElementProvider().invokeOperation("submodelElements/" + idShortPath + "/" + "invoke" + "?async=true", params);
    }

    private String buildValuePathForProperty(String idShortPath) {
        return "submodelElements/" + idShortPath + "/" + "value";
    }

    @Override
    public Object getOperationResult(String idShortPath, String requestId) {
        return this.getElementProvider().getValue("submodelElements/" + idShortPath + "/" + "invocationList" + "/" + requestId);
    }
}

