/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;

public class BaSyxMqttConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxMQTT_";
    public static final String DEFAULT_USER = "";
    public static final String DEFAULT_PASS = "";
    public static final String DEFAULT_SERVER = "http://localhost:1883/";
    public static final String DEFAULT_QOS = "1";
    public static final String USER = "user";
    public static final String PASS = "pass";
    public static final String SERVER = "server";
    public static final String QOS = "qos";
    public static final String WHITELIST_PREFIX = "whitelist.";
    public static final String WHITELIST_ELEMENT_PREFIX = "whitelist.element.";
    public static final String DEFAULT_CONFIG_PATH = "mqtt.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_MQTT";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(USER, "");
        defaultProps.put(PASS, "");
        defaultProps.put(SERVER, DEFAULT_SERVER);
        defaultProps.put(QOS, DEFAULT_QOS);
        return defaultProps;
    }

    public BaSyxMqttConfiguration(Map<String, String> values) {
        super(values);
    }

    public BaSyxMqttConfiguration() {
        super(BaSyxMqttConfiguration.getDefaultProperties());
    }

    public BaSyxMqttConfiguration(String user, String pass, String server, int qos) {
        this();
        this.setUser(user);
        this.setPass(pass);
        this.setServer(server);
        this.setQoS(qos);
    }

    public void loadFromEnvironmentVariables() {
        String[] properties = new String[]{USER, PASS, SERVER, QOS};
        this.loadFromEnvironmentVariables(ENV_PREFIX, properties);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public String getUser() {
        return this.getProperty(USER);
    }

    public void setUser(String user) {
        this.setProperty(USER, user);
    }

    public String getPass() {
        return this.getProperty(PASS);
    }

    public void setPass(String pass) {
        this.setProperty(PASS, pass);
    }

    public String getServer() {
        return this.getProperty(SERVER);
    }

    public void setServer(String server) {
        this.setProperty(SERVER, server);
    }

    public int getQoS() {
        return Integer.parseInt(this.getProperty(QOS));
    }

    public void setQoS(int qos) {
        this.setProperty(QOS, Integer.toString(qos));
    }

    public boolean isWhitelistEnabled(String submodelId) {
        return "true".equals(this.getProperty(WHITELIST_PREFIX + submodelId));
    }

    public void setWhitelistEnabled(String submodelId, boolean enabled) {
        String propertyName = WHITELIST_PREFIX + submodelId;
        if (enabled) {
            this.setProperty(propertyName, "true");
        } else {
            this.setProperty(propertyName, "false");
        }
    }

    public Set<String> getWhitelist(String submodelId) {
        HashSet<String> whitelist = new HashSet<String>();
        String fullPrefix = WHITELIST_ELEMENT_PREFIX + submodelId;
        List<String> properties = this.getProperties(fullPrefix);
        for (String prop : properties) {
            if (!this.getProperty(prop).equals("true")) continue;
            String elementId = prop.substring(fullPrefix.length() + 1);
            whitelist.add(elementId);
        }
        return whitelist;
    }

    public void setWhitelist(String submodelId, List<String> elementIds) {
        String smPrefix = WHITELIST_ELEMENT_PREFIX + submodelId;
        for (String elemId : elementIds) {
            String propName = smPrefix + "." + elemId;
            this.setProperty(propName, "true");
        }
    }
}

