/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.AbstractSubmodel;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxBlob;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxDataElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxEntity;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxFile;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxMultiLanguageProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxOperation;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxProperty;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRange;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReferenceElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxRelationshipElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementList;
import de.iip_ecosphere.platform.support.aas.basyx.VabInvocablesCreator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.basyx.submodel.metamodel.api.IElementContainer;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IReferenceElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.Blob;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.DataElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.range.Range;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class BaSyxElementTranslator {
    static void registerSubmodelElements(Map<String, ISubmodelElement> elements, SubmodelElementsRegistrar reg) {
        BaSyxElementTranslator.registerSubmodelElements(elements.values(), reg);
    }

    static void registerSubmodelElements(Collection<ISubmodelElement> elements, SubmodelElementsRegistrar reg) {
        for (ISubmodelElement se : elements) {
            BaSyxElementTranslator.registerSubmodelElement(se, reg);
        }
    }

    static void registerSubmodelElement(ISubmodelElement se, SubmodelElementsRegistrar reg) {
        if (se instanceof IProperty) {
            reg.register(new BaSyxProperty((IProperty)se));
        } else if (se instanceof IOperation) {
            reg.register(new BaSyxOperation((IOperation)se));
        } else if (se instanceof IReferenceElement) {
            reg.register(new BaSyxReferenceElement((IReferenceElement)se));
        } else if (se instanceof ISubmodelElementCollection) {
            ISubmodelElementCollection c = (ISubmodelElementCollection)se;
            if (c.isOrdered()) {
                reg.register(new BaSyxSubmodelElementList(c));
            } else {
                reg.register(new BaSyxSubmodelElementCollection(c));
            }
        } else if (se instanceof File) {
            reg.register(new BaSyxFile((File)se));
        } else if (se instanceof Blob) {
            reg.register(new BaSyxBlob((Blob)se));
        } else if (se instanceof Range) {
            reg.register(new BaSyxRange((Range)se));
        } else if (se instanceof RelationshipElement) {
            reg.register(new BaSyxRelationshipElement((RelationshipElement)se));
        }
    }

    static <T extends SubmodelElement> boolean matchesType(ISubmodelElement elt, Class<T> cls) {
        boolean result = Property.class.isAssignableFrom(cls) ? IProperty.class.isInstance(elt) : (VabInvocablesCreator.Operation.class.isAssignableFrom(cls) ? IOperation.class.isInstance(elt) : (ReferenceElement.class.isAssignableFrom(cls) ? IReferenceElement.class.isInstance(elt) : (SubmodelElementCollection.class.isAssignableFrom(cls) ? ISubmodelElementCollection.class.isInstance(elt) : (FileDataElement.class.isAssignableFrom(cls) ? File.class.isInstance(elt) : (SubmodelElement.class.isAssignableFrom(cls) ? ISubmodelElement.class.isInstance(elt) : false)))));
        return result;
    }

    static <T extends SubmodelElement> boolean iterate(IElementContainer cont, Submodel.IteratorFunction<T> func, Class<T> cls, String ... path) {
        boolean result = false;
        if ((cont = BaSyxElementTranslator.findInPath(cont, path)) instanceof IElementContainer) {
            IterationSubmodelElementsRegistrar<T> reg = new IterationSubmodelElementsRegistrar<T>(func, cls);
            for (ISubmodelElement e : cont.getSubmodelElements().values()) {
                if (!BaSyxElementTranslator.matchesType(e, cls)) continue;
                BaSyxElementTranslator.registerSubmodelElement(e, reg);
                if (reg.isContinue()) continue;
                break;
            }
            result = reg.wasApplied();
        }
        return result;
    }

    static boolean create(Submodel sub, Consumer<SubmodelElementContainerBuilder> func, boolean propagate, String ... path) {
        SubmodelElementContainerBuilder builder = null;
        if (path.length > 0) {
            builder = sub.createSubmodelElementContainerBuilder(path[0]);
            if (builder.isNew()) {
                builder = null;
            } else {
                for (int i = 1; i < path.length; ++i) {
                    if (!(builder = builder.createSubmodelElementContainerBuilder(path[i])).isNew()) continue;
                    builder = null;
                    break;
                }
            }
        } else {
            builder = ((AbstractSubmodel)sub).getAas().createAasBuilder().createSubmodelBuilder(sub.getIdShort(), sub.getIdentification());
        }
        if (builder != null) {
            if (builder instanceof BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder) {
                ((BaSyxSubmodelElementCollection.BaSyxSubmodelElementCollectionBuilder)builder).setPropagation(propagate);
            }
            func.accept(builder);
        }
        return builder != null;
    }

    static IElementContainer findInPath(IElementContainer cont, String ... path) {
        for (int i = 0; i < path.length; ++i) {
            try {
                ISubmodelElement elt = cont.getSubmodelElement(path[i]);
                if (elt instanceof IElementContainer) {
                    cont = (IElementContainer)elt;
                    continue;
                }
                cont = null;
            }
            catch (ResourceNotFoundException e) {
                cont = null;
            }
            break;
        }
        return cont;
    }

    static interface SubmodelElementsRegistrar {
        public <T extends SubmodelElement> T registerElement(T var1);

        default public BaSyxProperty register(BaSyxProperty property) {
            return this.registerElement(property);
        }

        default public BaSyxFile register(BaSyxFile file) {
            return this.registerElement(file);
        }

        default public BaSyxRange register(BaSyxRange range) {
            return this.registerElement(range);
        }

        default public BaSyxBlob register(BaSyxBlob blob) {
            return this.registerElement(blob);
        }

        default public BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
            return this.registerElement(property);
        }

        default public BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
            return this.registerElement(relationship);
        }

        default public BaSyxEntity register(BaSyxEntity entity) {
            return this.registerElement(entity);
        }

        default public BaSyxOperation register(BaSyxOperation operation) {
            return this.registerElement(operation);
        }

        default public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
            return this.registerElement(reference);
        }

        default public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
            return this.registerElement(collection);
        }

        default public BaSyxSubmodelElementList register(BaSyxSubmodelElementList list) {
            return this.registerElement(list);
        }

        default public <D extends DataElement> BaSyxDataElement<D> register(BaSyxDataElement<D> dataElement) {
            return this.registerElement(dataElement);
        }
    }

    private static class IterationSubmodelElementsRegistrar<T extends SubmodelElement>
    implements SubmodelElementsRegistrar {
        private Submodel.IteratorFunction<T> func;
        private Class<T> cls;
        private boolean applied;
        private boolean cont = true;

        private IterationSubmodelElementsRegistrar(Submodel.IteratorFunction<T> func, Class<T> cls) {
            this.func = func;
            this.cls = cls;
        }

        private <S> S accept(S elt) {
            this.cont = this.func.apply((SubmodelElement)this.cls.cast(elt));
            this.applied = true;
            return elt;
        }

        public <E extends SubmodelElement> E registerElement(E elt) {
            return this.accept(elt);
        }

        @Override
        public BaSyxProperty register(BaSyxProperty property) {
            return this.accept(property);
        }

        @Override
        public BaSyxFile register(BaSyxFile file) {
            return this.accept(file);
        }

        @Override
        public BaSyxRange register(BaSyxRange range) {
            return this.accept(range);
        }

        @Override
        public BaSyxBlob register(BaSyxBlob blob) {
            return this.accept(blob);
        }

        @Override
        public BaSyxMultiLanguageProperty register(BaSyxMultiLanguageProperty property) {
            return this.accept(property);
        }

        @Override
        public BaSyxOperation register(BaSyxOperation operation) {
            return this.accept(operation);
        }

        @Override
        public BaSyxRelationshipElement register(BaSyxRelationshipElement relationship) {
            return this.accept(relationship);
        }

        @Override
        public BaSyxEntity register(BaSyxEntity entity) {
            return this.accept(entity);
        }

        @Override
        public BaSyxReferenceElement register(BaSyxReferenceElement reference) {
            return this.accept(reference);
        }

        @Override
        public BaSyxSubmodelElementCollection register(BaSyxSubmodelElementCollection collection) {
            return this.accept(collection);
        }

        @Override
        public <D extends DataElement> BaSyxDataElement<D> register(BaSyxDataElement<D> dataElement) {
            return this.accept(dataElement);
        }

        private boolean wasApplied() {
            return this.applied;
        }

        private boolean isContinue() {
            return this.cont;
        }
    }
}

