/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.aggregator.restapi;

import java.util.Map;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.map.identifier.Identifier;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class AASAggregatorProvider
implements IModelProvider {
    private IAASAggregator aggregator;
    public static final String PREFIX = "shells";

    public AASAggregatorProvider(IAASAggregator aggregator) {
        this.aggregator = aggregator;
    }

    private String stripPrefix(String path) throws MalformedRequestException {
        if (!(path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            throw new MalformedRequestException("Path " + path + " not recognized as aggregator path. Has to start with " + PREFIX);
        }
        path = path.replaceFirst(PREFIX, "");
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    private AssetAdministrationShell createAASFromMap(Object value) throws MalformedRequestException {
        if (!(value instanceof Map)) {
            throw new MalformedRequestException("Given newValue is not a Map");
        }
        Map map = (Map)value;
        String type = ModelType.createAsFacade(map).getName();
        if (!"AssetAdministrationShell".equals(type) && type != null) {
            throw new MalformedRequestException("Given newValue map has not the correct ModelType");
        }
        AssetAdministrationShell aas = AssetAdministrationShell.createAsFacade(map);
        return aas;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        if ((path = this.stripPrefix(path)).isEmpty()) {
            return this.aggregator.getAASList();
        }
        String[] splitted = VABPathTools.splitPath(path);
        if (splitted.length == 1) {
            String id = VABPathTools.decodePathElement(splitted[0]);
            IAssetAdministrationShell aas = this.aggregator.getAAS(new ModelUrn(id));
            return aas;
        }
        String id = VABPathTools.decodePathElement(splitted[0]);
        String restPath = VABPathTools.skipEntries(path, 1);
        Identifier identifier = new Identifier(IdentifierType.CUSTOM, id);
        return this.aggregator.getAASProvider(identifier).getValue(restPath);
    }

    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        if (!(path = this.stripPrefix(path)).isEmpty()) {
            if (!path.contains("/")) {
                AssetAdministrationShell aas = this.createAASFromMap(newValue);
                path = VABPathTools.decodePathElement(path);
                ModelUrn identifier = new ModelUrn(path);
                if (!aas.getIdentification().getId().equals(path)) {
                    throw new MalformedRequestException("Given aasID and given AAS do not match");
                }
                try {
                    this.aggregator.getAAS(identifier);
                    this.aggregator.updateAAS(aas);
                }
                catch (ResourceNotFoundException e) {
                    this.aggregator.createAAS(aas);
                }
            } else {
                String id = VABPathTools.decodePathElement(VABPathTools.getEntry(path, 0));
                String restPath = VABPathTools.skipEntries(path, 1);
                Identifier identifier = new Identifier(IdentifierType.CUSTOM, id);
                this.aggregator.getAASProvider(identifier).setValue(restPath, newValue);
            }
        } else {
            throw new MalformedRequestException("Set with empty path is not supported by aggregator");
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        if ((path = this.stripPrefix(path)).isEmpty()) {
            throw new MalformedRequestException("Create with empty path is not supported by aggregator");
        }
        String id = VABPathTools.decodePathElement(VABPathTools.getEntry(path, 0));
        String restPath = VABPathTools.skipEntries(path, 1);
        Identifier identifier = new Identifier(IdentifierType.CUSTOM, id);
        this.aggregator.getAASProvider(identifier).createValue(restPath, newEntity);
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        if (!(path = this.stripPrefix(path)).isEmpty()) {
            if (!path.contains("/")) {
                String aasId = VABPathTools.decodePathElement(path);
                ModelUrn identifier = new ModelUrn(aasId);
                if (this.aggregator.getAAS(identifier) == null) {
                    throw new ResourceNotFoundException("Value '" + aasId + "' to be deleted does not exists.");
                }
                this.aggregator.deleteAAS(identifier);
            } else {
                String id = VABPathTools.decodePathElement(VABPathTools.getEntry(path, 0));
                String restPath = VABPathTools.skipEntries(path, 1);
                Identifier identifier = new Identifier(IdentifierType.CUSTOM, id);
                this.aggregator.getAASProvider(identifier).deleteValue(restPath);
            }
        } else {
            throw new MalformedRequestException("Delete with empty path is not supported by registry");
        }
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("DeleteValue with parameter not supported by aggregator");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        path = this.stripPrefix(path);
        String id = VABPathTools.decodePathElement(VABPathTools.getEntry(path, 0));
        String restPath = VABPathTools.skipEntries(path, 1);
        Identifier identifier = new Identifier(IdentifierType.CUSTOM, id);
        return this.aggregator.getAASProvider(identifier).invokeOperation(restPath, parameter);
    }
}

