/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.aasx;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AasEnv;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;

public class AASXPackageExplorerConformantHelper {
    public static AasEnv adapt(Collection<IAssetAdministrationShell> aasList, Collection<IAsset> assetList, Collection<IConceptDescription> conceptDescriptionList, Collection<ISubmodel> submodelList) {
        Collection convertedAASs = aasList.stream().map(AASXPackageExplorerConformantHelper::removeFirstKeyFromSubmodelReferences).collect(Collectors.toList());
        return new AasEnv(convertedAASs, assetList, conceptDescriptionList, submodelList);
    }

    public static AasEnv adapt(AasEnv env) {
        return AASXPackageExplorerConformantHelper.adapt(env.getAssetAdministrationShells(), env.getAssets(), env.getConceptDescriptions(), env.getSubmodels());
    }

    private static IAssetAdministrationShell removeFirstKeyFromSubmodelReferences(IAssetAdministrationShell shell) {
        Collection convertedReferences = shell.getSubmodelReferences().stream().map(AASXPackageExplorerConformantHelper::removeFirstKeyElement).collect(Collectors.toList());
        ((AssetAdministrationShell)shell).setSubmodelReferences(convertedReferences);
        return shell;
    }

    private static IReference removeFirstKeyElement(IReference reference) {
        List<IKey> keys = reference.getKeys();
        keys.remove(0);
        Reference ref = new Reference(keys);
        return ref;
    }
}

