/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.restapi;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.ModelUrn;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.memory.InMemoryRegistry;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;

public class AASRegistryModelProvider
implements IModelProvider {
    IAASRegistry registry;
    public static final String PREFIX = "api/v1/registry";
    public static final String SUBMODELS = "submodels";

    public AASRegistryModelProvider(IAASRegistry registry) {
        this.registry = registry;
    }

    public AASRegistryModelProvider() {
        this(new InMemoryRegistry());
    }

    private String stripPrefix(String path) throws MalformedRequestException {
        if (!(path = VABPathTools.stripSlashes(path)).startsWith(PREFIX)) {
            throw new MalformedRequestException("Path " + path + " not recognized as registry path. Has to start with " + PREFIX);
        }
        path = path.replaceFirst(PREFIX, "");
        path = VABPathTools.stripSlashes(path);
        return path;
    }

    private String[] splitPath(String path) throws MalformedRequestException {
        if (path.isEmpty()) {
            return new String[0];
        }
        String[] splitted = path.split("/");
        if (splitted[0].equals(SUBMODELS)) {
            throw new MalformedRequestException("Path must not start with submodels");
        }
        if (splitted.length > 1 && !splitted[1].equals(SUBMODELS)) {
            throw new MalformedRequestException("Second path element must be (if present): submodels");
        }
        return splitted;
    }

    private String[] preparePath(String path) throws MalformedRequestException {
        path = this.stripPrefix(path);
        String[] splitted = this.splitPath(path);
        try {
            for (int i = 0; i < splitted.length; ++i) {
                splitted[i] = URLDecoder.decode(splitted[i], "UTF-8");
            }
            return splitted;
        }
        catch (UnsupportedEncodingException e) {
            throw new MalformedRequestException("Path has to be encoded as UTF-8 string.");
        }
    }

    private Map<String, Object> checkModelType(String expectedModelType, Object value) throws MalformedRequestException {
        if (!(value instanceof Map)) {
            throw new MalformedRequestException("Given newValue is not a Map");
        }
        Map map = (Map)value;
        String type = ModelType.createAsFacade(map).getName();
        if (!expectedModelType.equals(type) && type != null) {
            throw new MalformedRequestException("Given newValue map has not the correct ModelType");
        }
        return map;
    }

    private AASDescriptor createAASDescriptorFromMap(Object value) throws MalformedRequestException {
        Map<String, Object> map = this.checkModelType("AssetAdministrationShellDescriptor", value);
        AASDescriptor aasDescriptor = new AASDescriptor(map);
        return aasDescriptor;
    }

    private SubmodelDescriptor createSMDescriptorFromMap(Object value) throws MalformedRequestException {
        Map<String, Object> map = this.checkModelType("SubmodelDescriptor", value);
        SubmodelDescriptor smDescriptor = new SubmodelDescriptor(map);
        return smDescriptor;
    }

    @Override
    public Object getValue(String path) throws ProviderException {
        String[] splitted = this.preparePath(path);
        if (splitted.length == 0) {
            return this.registry.lookupAll();
        }
        if (splitted.length == 1) {
            AASDescriptor descriptor = this.registry.lookupAAS(new ModelUrn(splitted[0]));
            if (descriptor == null) {
                throw new ResourceNotFoundException("Specified AASid '" + splitted[0] + "' does not exist.");
            }
            return descriptor;
        }
        if (splitted.length == 2) {
            return this.getSmDescriptorsFromAAS(new ModelUrn(splitted[0]));
        }
        if (splitted.length == 3) {
            SubmodelDescriptor smDescriptor = this.getSmDescriptorFromAAS(new ModelUrn(splitted[0]), splitted[2]);
            if (smDescriptor == null) {
                throw new ResourceNotFoundException("Specified SubmodelId '" + splitted[2] + "' does not exist in AAS '" + splitted[0] + "'.");
            }
            return smDescriptor;
        }
        throw new MalformedRequestException("Given path '" + path + "' contains more than three path elements and is therefore invalid.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String path, Object newValue) throws ProviderException {
        String[] splitted = this.preparePath(path);
        if (splitted.length <= 0) throw new MalformedRequestException("Set with empty path is not supported by registry");
        ModelUrn identifier = new ModelUrn(splitted[0]);
        if (splitted.length == 1) {
            String urlId;
            AASDescriptor desc = this.createAASDescriptorFromMap(newValue);
            String descId = desc.getIdentifier().getId();
            if (!descId.equals(urlId = splitted[0])) throw new MalformedRequestException("The Identifier " + descId + " in the descriptor does not match the URL with id " + urlId);
            this.registry.register(desc);
            return;
        } else {
            if (splitted.length != 3) throw new MalformedRequestException("Unknown path " + path);
            SubmodelDescriptor smDesc = this.createSMDescriptorFromMap(newValue);
            this.registry.register(identifier, smDesc);
        }
    }

    @Override
    public void createValue(String path, Object newEntity) throws ProviderException {
        throw new MalformedRequestException("Create (POST) on a registry is not supported. Please, use put");
    }

    @Override
    public void deleteValue(String path) throws ProviderException {
        String[] splitted = this.preparePath(path);
        if (splitted.length == 1) {
            ModelUrn aasId = new ModelUrn(splitted[0]);
            if (this.registry.lookupAAS(aasId) == null) {
                throw new ResourceNotFoundException("AAS '" + splitted[0] + "' to be deleted does not exist.");
            }
            this.registry.delete(aasId);
        } else if (splitted.length == 3) {
            ModelUrn aasId = new ModelUrn(splitted[0]);
            String smId = splitted[2];
            SubmodelDescriptor smDesc = this.getSmDescriptorFromAAS(aasId, smId);
            if (smDesc == null) {
                throw new ResourceNotFoundException("A Submodel with id '" + smId + "' does not exist in aas '" + splitted[0] + "'.");
            }
            this.registry.delete(aasId, smDesc.getIdentifier());
        } else {
            throw new MalformedRequestException("Delete with empty path is not supported by registry");
        }
    }

    @Override
    public void deleteValue(String path, Object obj) throws ProviderException {
        throw new MalformedRequestException("DeleteValue with parameter not supported by registry");
    }

    @Override
    public Object invokeOperation(String path, Object ... parameter) throws ProviderException {
        throw new MalformedRequestException("Invoke not supported by registry");
    }

    private Collection<SubmodelDescriptor> getSmDescriptorsFromAAS(IIdentifier id) throws ResourceNotFoundException {
        AASDescriptor aasDescriptor = this.registry.lookupAAS(id);
        if (aasDescriptor == null) {
            throw new ResourceNotFoundException("Specified AASid '" + id.getId() + "' does not exist.");
        }
        return aasDescriptor.getSubmodelDescriptors();
    }

    private SubmodelDescriptor getSmDescriptorFromAAS(IIdentifier aasId, String smId) throws ResourceNotFoundException {
        AASDescriptor aasDescriptor = this.registry.lookupAAS(aasId);
        if (aasDescriptor == null) {
            throw new ResourceNotFoundException("Specified AASId '" + aasId.getId() + "' does not exist.");
        }
        SubmodelDescriptor smDescriptor = aasDescriptor.getSubmodelDescriptorFromIdentifierId(smId);
        if (smDescriptor == null) {
            throw new ResourceNotFoundException("Specified SMId '" + smId + "' for AAS " + aasId.getId() + " does not exist.");
        }
        return smDescriptor;
    }
}

