/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.qualifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.api.dataspecification.DataSpecificationIEC61360XMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.reference.ReferenceXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IDataSpecificationContent;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IDataSpecificationIEC61360Content;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IEmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IHasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.map.dataspecification.DataSpecificationContent;
import org.eclipse.basyx.submodel.metamodel.map.dataspecification.DataSpecificationIEC61360Content;
import org.eclipse.basyx.submodel.metamodel.map.dataspecification.EmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HasDataSpecificationXMLConverter {
    public static final String EMBEDDED_DATA_SPECIFICATION = "aas:embeddedDataSpecification";
    public static final String DATA_SPECIFICATION_IEC61360 = "aas:dataSpecificationIEC61360";
    public static final String DATA_SPECIFICATION_REFERENCE = "aas:dataSpecification";
    public static final String DATA_SPECIFICATION_CONTENT = "aas:dataSpecificationContent";

    public static void populateHasDataSpecification(Map<String, Object> xmlObject, HasDataSpecification hasDataSpecification) {
        if (xmlObject == null || hasDataSpecification == null) {
            return;
        }
        Object xmlDataSpecObj = xmlObject.get(EMBEDDED_DATA_SPECIFICATION);
        if (xmlDataSpecObj != null) {
            ArrayList<IEmbeddedDataSpecification> embeddedSpecList = new ArrayList<IEmbeddedDataSpecification>();
            List<Map<String, Object>> xmlSpecList = XMLHelper.getList(xmlDataSpecObj);
            for (Map<String, Object> xmlSpec : xmlSpecList) {
                Reference ref = HasDataSpecificationXMLConverter.parseReference(xmlSpec);
                IDataSpecificationContent content = HasDataSpecificationXMLConverter.parseContent(xmlSpec);
                EmbeddedDataSpecification spec = new EmbeddedDataSpecification();
                spec.setDataSpecificationTemplate(ref);
                spec.setContent((DataSpecificationIEC61360Content)content);
                embeddedSpecList.add(spec);
            }
            hasDataSpecification.setEmbeddedDataSpecifications(embeddedSpecList);
        }
    }

    private static Reference parseReference(Map<String, Object> xmlSpec) {
        Map refMap = (Map)xmlSpec.get(DATA_SPECIFICATION_REFERENCE);
        if (refMap == null) {
            return null;
        }
        return ReferenceXMLConverter.parseReference(refMap);
    }

    private static IDataSpecificationContent parseContent(Map<String, Object> xmlSpec) {
        Map contentMap = (Map)xmlSpec.get(DATA_SPECIFICATION_CONTENT);
        if (contentMap == null) {
            return null;
        }
        if (contentMap.containsKey(DATA_SPECIFICATION_IEC61360)) {
            Map iec61360ContentMap = (Map)contentMap.get(DATA_SPECIFICATION_IEC61360);
            return DataSpecificationIEC61360XMLConverter.parseDataSpecificationContent(iec61360ContentMap);
        }
        return new DataSpecificationContent();
    }

    public static void populateHasDataSpecificationXML(Document document, Element root, IHasDataSpecification hasDataSpecification) {
        Collection<IEmbeddedDataSpecification> specs = hasDataSpecification.getEmbeddedDataSpecifications();
        for (IEmbeddedDataSpecification spec : specs) {
            Element embeddedDataSpecRoot = document.createElement(EMBEDDED_DATA_SPECIFICATION);
            IDataSpecificationContent content = spec.getContent();
            Element dataSpecContentRoot = document.createElement(DATA_SPECIFICATION_CONTENT);
            embeddedDataSpecRoot.appendChild(dataSpecContentRoot);
            if (content instanceof Map) {
                Element dataSpecIEC61360Root = document.createElement(DATA_SPECIFICATION_IEC61360);
                dataSpecContentRoot.appendChild(dataSpecIEC61360Root);
                HasDataSpecificationXMLConverter.populateContent(document, dataSpecIEC61360Root, DataSpecificationIEC61360Content.createAsFacade((Map)((Object)content)));
            }
            IReference dataSpecTemplate = spec.getDataSpecificationTemplate();
            Element dataSpecTemplateRoot = document.createElement(DATA_SPECIFICATION_REFERENCE);
            embeddedDataSpecRoot.appendChild(dataSpecTemplateRoot);
            dataSpecTemplateRoot.appendChild(ReferenceXMLConverter.buildReferenceXML(document, dataSpecTemplate));
            root.appendChild(embeddedDataSpecRoot);
        }
    }

    private static void populateContent(Document document, Element contentRoot, IDataSpecificationContent content) {
        DataSpecificationIEC61360XMLConverter.populateIEC61360ContentXML(document, contentRoot, (IDataSpecificationIEC61360Content)content);
    }
}

