/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.IElementContainer;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.dataspecification.IEmbeddedDataSpecification;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IdentifierType;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.IAdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.haskind.ModelingKind;
import org.eclipse.basyx.submodel.metamodel.api.qualifier.qualifiable.IConstraint;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelValuesHelper;
import org.eclipse.basyx.submodel.metamodel.map.helper.ElementContainerHelper;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.AdministrativeInformation;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasSemantics;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Identifiable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.haskind.HasKind;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.qualifiable.Qualifiable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;
import org.eclipse.basyx.vab.model.VABModelMap;

public class Submodel
extends VABModelMap<Object>
implements IElementContainer,
ISubmodel {
    public static final String SUBMODELELEMENT = "submodelElements";
    public static final String MODELTYPE = "Submodel";

    public Submodel() {
        this.putAll(new Identifiable());
        this.putAll(new HasDataSpecification());
        this.putAll(new ModelType(MODELTYPE));
        this.setModelingKind(ModelingKind.INSTANCE);
        this.put(SUBMODELELEMENT, new HashMap());
    }

    public Submodel(String idShort, IIdentifier identification) {
        this();
        this.setIdentification(identification);
        this.setIdShort(idShort);
    }

    public Submodel(HasSemantics semantics, Identifiable identifiable, Qualifiable qualifiable, HasDataSpecification specification, HasKind hasKind) {
        this();
        this.putAll(semantics);
        this.putAll(identifiable);
        this.putAll(qualifiable);
        this.putAll(specification);
        this.putAll(hasKind);
        this.put(SUBMODELELEMENT, new HashMap());
    }

    public Submodel(List<Property> properties) {
        this();
        properties.forEach(this::addSubmodelElement);
    }

    public Submodel(List<Property> properties, List<Operation> operations) {
        this();
        properties.forEach(this::addSubmodelElement);
        operations.forEach(this::addSubmodelElement);
    }

    public static Submodel createAsFacade(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (!Submodel.isValid(map)) {
            throw new MetamodelConstructionException(Submodel.class, map);
        }
        if (!map.containsKey(SUBMODELELEMENT)) {
            map.put(SUBMODELELEMENT, new ArrayList());
        }
        return SubmodelElementMapCollectionConverter.mapToSM(map);
    }

    public static boolean isValid(Map<String, Object> map) {
        return Identifiable.isValid(map);
    }

    @Override
    public IReference getSemanticId() {
        return HasSemantics.createAsFacade(this).getSemanticId();
    }

    public void setSemanticId(IReference ref) {
        HasSemantics.createAsFacade(this).setSemanticId(ref);
    }

    @Override
    public IAdministrativeInformation getAdministration() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getAdministration();
    }

    @Override
    public IIdentifier getIdentification() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getIdentification();
    }

    public void setAdministration(AdministrativeInformation information) {
        Identifiable.createAsFacade(this, this.getKeyElement()).setAdministration(information);
    }

    public void setIdentification(IIdentifier id) {
        this.setIdentification(id.getIdType(), id.getId());
    }

    public void setIdentification(IdentifierType idType, String id) {
        Identifiable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdentification(idType, id);
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public Collection<IEmbeddedDataSpecification> getEmbeddedDataSpecifications() {
        return HasDataSpecification.createAsFacade(this).getEmbeddedDataSpecifications();
    }

    public void setEmbeddedDataSpecifications(Collection<IEmbeddedDataSpecification> embeddedDataSpecifications) {
        HasDataSpecification.createAsFacade(this).setEmbeddedDataSpecifications(embeddedDataSpecifications);
    }

    @Override
    public ModelingKind getModelingKind() {
        return HasKind.createAsFacade(this).getModelingKind();
    }

    public void setModelingKind(ModelingKind kind) {
        HasKind.createAsFacade(this).setModelingKind(kind);
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    public void setIdShort(String id) {
        Referable.createAsFacadeNonStrict(this, this.getKeyElement()).setIdShort(id);
    }

    public void setProperties(Map<String, IProperty> properties) {
        Set<Map.Entry<String, ISubmodelElement>> elementSet = this.getSubmodelElements().entrySet();
        Iterator<Map.Entry<String, ISubmodelElement>> iterator = elementSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ISubmodelElement> entry = iterator.next();
            if (!(entry.getValue() instanceof IProperty)) continue;
            iterator.remove();
        }
        properties.values().forEach(this::addSubmodelElement);
    }

    public void setOperations(Map<String, IOperation> operations) {
        Set<Map.Entry<String, ISubmodelElement>> elementSet = this.getSubmodelElements().entrySet();
        Iterator<Map.Entry<String, ISubmodelElement>> iterator = elementSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ISubmodelElement> entry = iterator.next();
            if (!(entry.getValue() instanceof IOperation)) continue;
            iterator.remove();
        }
        operations.values().forEach(this::addSubmodelElement);
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    public IReference getParent() {
        return Referable.createAsFacade(this, this.getKeyElement()).getParent();
    }

    public void setCategory(String category) {
        Referable.createAsFacade(this, this.getKeyElement()).setCategory(category);
    }

    public void setDescription(LangStrings description) {
        Referable.createAsFacade(this, this.getKeyElement()).setDescription(description);
    }

    public void setParent(IReference obj) {
        Referable.createAsFacade(this, this.getKeyElement()).setParent(obj);
    }

    private KeyElements getKeyElement() {
        return KeyElements.SUBMODEL;
    }

    @Override
    public void addSubmodelElement(ISubmodelElement element) {
        if (element instanceof SubmodelElement) {
            ((SubmodelElement)element).setParent(this.getReference());
        }
        this.getSubmodelElements().put(element.getIdShort(), element);
    }

    @Override
    public Map<String, IProperty> getProperties() {
        HashMap<String, IProperty> properties = new HashMap<String, IProperty>();
        this.getSubmodelElements().values().forEach((? super T e) -> {
            if (e instanceof IProperty) {
                properties.put(e.getIdShort(), (IProperty)e);
            }
        });
        return properties;
    }

    @Override
    public Map<String, IOperation> getOperations() {
        HashMap<String, IOperation> operations = new HashMap<String, IOperation>();
        this.getSubmodelElements().values().forEach((? super T e) -> {
            if (e instanceof IOperation) {
                operations.put(e.getIdShort(), (IOperation)e);
            }
        });
        return operations;
    }

    @Override
    public Map<String, ISubmodelElement> getSubmodelElements() {
        return (Map)this.get(SUBMODELELEMENT);
    }

    @Override
    public Map<String, Object> getValues() {
        return SubmodelValuesHelper.getSubmodelValue(this);
    }

    @Override
    public Collection<IConstraint> getQualifiers() {
        return Qualifiable.createAsFacade(this).getQualifiers();
    }

    public void setQualifiers(Collection<IConstraint> qualifiers) {
        Qualifiable.createAsFacade(this).setQualifiers(qualifiers);
    }

    @Override
    public IReference getReference() {
        return Identifiable.createAsFacade(this, this.getKeyElement()).getReference();
    }

    @Override
    public ISubmodelElement getSubmodelElement(String id) {
        Map<String, ISubmodelElement> submodelElems = this.getSubmodelElements();
        return ElementContainerHelper.getElementById(submodelElems, id);
    }

    @Override
    public void deleteSubmodelElement(String id) {
        Map<String, ISubmodelElement> submodelElems = this.getSubmodelElements();
        ElementContainerHelper.removeElementById(submodelElems, id);
    }
}

