/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.IElementContainer;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IProperty;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.map.helper.ElementContainerHelper;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.property.Property;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.Operation;

public class SubmodelElementCollection
extends SubmodelElement
implements ISubmodelElementCollection,
IElementContainer {
    public static final String ORDERED = "ordered";
    public static final String ALLOWDUPLICATES = "allowDuplicates";
    public static final String MODELTYPE = "SubmodelElementCollection";

    public SubmodelElementCollection() {
        this.putAll(new ModelType(MODELTYPE));
        this.put("value", new HashMap());
        this.put(ORDERED, Boolean.valueOf(true));
        this.put(ALLOWDUPLICATES, Boolean.valueOf(true));
    }

    public SubmodelElementCollection(String idShort) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
        this.setValue(new ArrayList());
        this.setOrdered(true);
        this.setAllowDuplicates(true);
    }

    public SubmodelElementCollection(Collection<ISubmodelElement> value, boolean ordered, boolean allowDuplicates) {
        this.putAll(new ModelType(MODELTYPE));
        this.put("value", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(value));
        this.put(ORDERED, Boolean.valueOf(ordered));
        this.put(ALLOWDUPLICATES, Boolean.valueOf(allowDuplicates));
    }

    public static SubmodelElementCollection createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!SubmodelElementCollection.isValid(obj)) {
            throw new MetamodelConstructionException(SubmodelElementCollection.class, obj);
        }
        return SubmodelElementMapCollectionConverter.mapToSmECollection(obj);
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj);
    }

    public static boolean isSubmodelElementCollection(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey("value") && map.containsKey(ORDERED) && map.containsKey(ALLOWDUPLICATES);
    }

    @Override
    public void addSubmodelElement(ISubmodelElement elem) {
        if (elem instanceof SubmodelElement) {
            ((SubmodelElement)elem).setParent(this.getReference());
        }
        ((Map)this.get("value")).put(elem.getIdShort(), elem);
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    @Override
    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    public void setValue(Object value) {
        this.put("value", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(value));
    }

    @Override
    public Collection<ISubmodelElement> getValue() {
        return Collections.unmodifiableList(new ArrayList<ISubmodelElement>(this.getSubmodelElements().values()));
    }

    public void setOrdered(boolean value) {
        this.put(ORDERED, Boolean.valueOf(value));
    }

    @Override
    public boolean isOrdered() {
        return (Boolean)this.get(ORDERED);
    }

    public void setAllowDuplicates(boolean value) {
        this.put(ALLOWDUPLICATES, Boolean.valueOf(value));
    }

    @Override
    public boolean isAllowDuplicates() {
        return (Boolean)this.get(ALLOWDUPLICATES);
    }

    public void setElements(Map<String, ISubmodelElement> value) {
        this.put("value", value);
    }

    public void setElements(Collection<ISubmodelElement> value) {
        this.put("value", SubmodelElementMapCollectionConverter.convertCollectionToIDMap(value));
    }

    @Override
    public Map<String, ISubmodelElement> getSubmodelElements() {
        return (Map)this.get("value");
    }

    @Override
    public Map<String, IProperty> getProperties() {
        HashMap<String, IProperty> ret = new HashMap<String, IProperty>();
        Map smElems = (Map)this.get("value");
        for (ISubmodelElement smElement : smElems.values()) {
            if (!Property.isProperty((Map)((Object)smElement))) continue;
            ret.put(smElement.getIdShort(), (IProperty)smElement);
        }
        return ret;
    }

    @Override
    public Map<String, IOperation> getOperations() {
        HashMap<String, IOperation> ret = new HashMap<String, IOperation>();
        Map smElems = (Map)this.get("value");
        for (ISubmodelElement smElement : smElems.values()) {
            if (!Operation.isOperation(smElement)) continue;
            ret.put(smElement.getIdShort(), (IOperation)smElement);
        }
        return ret;
    }

    @Override
    public ISubmodelElement getSubmodelElement(String id) {
        Map submodelElems = (Map)this.get("value");
        return ElementContainerHelper.getElementById(submodelElems, id);
    }

    @Override
    public void deleteSubmodelElement(String id) {
        Map submodelElems = (Map)this.get("value");
        ElementContainerHelper.removeElementById(submodelElems, id);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.SUBMODELELEMENTCOLLECTION;
    }

    @Override
    public SubmodelElementCollection getLocalCopy() {
        SubmodelElementCollection copy = new SubmodelElementCollection();
        copy.putAll(this);
        Object value = this.getValue();
        ArrayList clonedValue = new ArrayList();
        value.forEach((? super T element) -> clonedValue.add(element.getLocalCopy()));
        copy.setValue(clonedValue);
        return copy;
    }
}

