/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.entity.EntityType;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.entity.IEntity;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.entity.EntityValue;

public class Entity
extends SubmodelElement
implements IEntity {
    public static final String MODELTYPE = "Entity";
    public static final String STATEMENT = "statement";
    public static final String ENTITY_TYPE = "entityType";
    public static final String ASSET = "asset";

    public Entity() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public Entity(String idShort, EntityType entityType) {
        super(idShort);
        this.setEntityType(entityType);
        this.putAll(new ModelType(MODELTYPE));
    }

    public Entity(EntityType entityType, Collection<ISubmodelElement> statements, IReference asset) {
        this();
        this.setEntityType(entityType);
        this.setStatements(statements);
        this.setAsset(asset);
    }

    public void setStatements(Collection<ISubmodelElement> statements) {
        this.put(STATEMENT, statements);
    }

    public void setAsset(IReference asset) {
        this.put(ASSET, asset);
    }

    public void setEntityType(EntityType entityType) {
        this.put(ENTITY_TYPE, entityType.toString());
    }

    public static boolean isEntity(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(STATEMENT);
    }

    public static Entity createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Entity.isValid(obj)) {
            throw new MetamodelConstructionException(Entity.class, obj);
        }
        Entity facade = new Entity();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj) && obj.containsKey(ENTITY_TYPE);
    }

    @Override
    public Collection<ISubmodelElement> getStatements() {
        ArrayList<ISubmodelElement> ret = new ArrayList<ISubmodelElement>();
        Collection smElems = (Collection)this.get(STATEMENT);
        for (Object smElemO : smElems) {
            Map smElem = (Map)smElemO;
            ret.add(SubmodelElementFacadeFactory.createSubmodelElement(smElem));
        }
        return ret;
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.fromString((String)this.get(ENTITY_TYPE));
    }

    @Override
    public IReference getAsset() {
        return Reference.createAsFacade((Map)this.get(ASSET));
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.ENTITY;
    }

    @Override
    public EntityValue getValue() {
        return new EntityValue(this.getStatements(), this.getAsset());
    }

    @Override
    public void setValue(Object value) {
        if (!EntityValue.isEntityValue(value)) {
            throw new IllegalArgumentException("Given Object is not an EntityValue");
        }
        EntityValue ev = EntityValue.createAsFacade((Map)value);
        this.put(STATEMENT, ev.getStatement());
        this.put(ASSET, ev.getAsset());
    }

    @Override
    public Entity getLocalCopy() {
        Entity copy = new Entity();
        copy.putAll(this);
        return copy;
    }
}

