/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.coder.json.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.eclipse.basyx.vab.coder.json.metaprotocol.Result;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.GSONToolsFactory;
import org.eclipse.basyx.vab.exception.provider.MalformedRequestException;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONProvider<ModelProvider extends IModelProvider> {
    private static Logger logger = LoggerFactory.getLogger(JSONProvider.class);
    protected ModelProvider providerBackend = null;
    protected GSONTools serializer = null;

    public JSONProvider(ModelProvider modelProviderBackend) {
        this.providerBackend = modelProviderBackend;
        this.serializer = new GSONTools(new DefaultTypeFactory());
    }

    public JSONProvider(ModelProvider modelProviderBackend, GSONToolsFactory factory) {
        this.providerBackend = modelProviderBackend;
        this.serializer = new GSONTools(factory);
    }

    public GSONTools getSerializerReference() {
        return this.serializer;
    }

    public ModelProvider getBackendReference() {
        return this.providerBackend;
    }

    private String serialize(Exception e) {
        Result result = new Result(e);
        return this.serialize(result);
    }

    private String serialize(Result string) {
        return this.serializer.serialize(string);
    }

    private void sendException(OutputStream resp, Exception e) throws ProviderException {
        String jsonString = this.serialize(e);
        try {
            resp.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException innerE) {
            throw new ProviderException("Failed to send Exception '" + e.getMessage() + "' to client", innerE);
        }
        if (e instanceof ProviderException) {
            throw (ProviderException)e;
        }
        logger.error("Unknown Exception in JSONProvider", (Throwable)e);
        throw new ProviderException(e);
    }

    private Object extractParameter(String path, String serializedJSONValue, OutputStream outputStream) throws MalformedRequestException {
        Object result = null;
        try {
            result = this.serializer.deserialize(serializedJSONValue);
        }
        catch (Exception e) {
            throw new MalformedRequestException(e);
        }
        return result;
    }

    public void processBaSysGet(String path, OutputStream outputStream) throws ProviderException {
        try {
            Object value = this.providerBackend.getValue(path);
            String jsonString = this.serializer.serialize(value);
            outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.sendException(outputStream, e);
        }
    }

    public void processBaSysSet(String path, String serializedJSONValue, OutputStream outputStream) throws ProviderException {
        try {
            Object parameter = this.extractParameter(path, serializedJSONValue, outputStream);
            this.providerBackend.setValue(path, parameter);
            outputStream.write("".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.sendException(outputStream, e);
        }
    }

    public void processBaSysInvoke(String path, String serializedJSONValue, OutputStream outputStream) throws ProviderException {
        try {
            Object[] parameter = this.extractParameter(path, serializedJSONValue, outputStream);
            if (parameter instanceof Collection) {
                Collection list = (Collection)parameter;
                Object[] parameterArray = new Object[list.size()];
                int i = 0;
                for (Object o : list) {
                    parameterArray[i] = o;
                    ++i;
                }
                parameter = parameterArray;
            }
            if (!(parameter instanceof Object[])) {
                Object[] parameterArray = new Object[1];
                Object[] tmp = parameter;
                parameterArray[0] = tmp;
                parameter = parameterArray;
            }
            Object result = this.providerBackend.invokeOperation(path, parameter);
            String jsonString = this.serializer.serialize(result);
            outputStream.write(jsonString.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.sendException(outputStream, e);
        }
    }

    public void processBaSysDelete(String path, String serializedJSONValue, OutputStream outputStream) throws ProviderException {
        try {
            Object parameter = this.extractParameter(path, serializedJSONValue, outputStream);
            if (parameter == null) {
                this.providerBackend.deleteValue(path);
            } else {
                this.providerBackend.deleteValue(path, parameter);
            }
            outputStream.write("".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.sendException(outputStream, e);
        }
    }

    public void processBaSysCreate(String path, String serializedJSONValue, OutputStream outputStream) throws ProviderException {
        try {
            Object parameter = this.extractParameter(path, serializedJSONValue, outputStream);
            this.providerBackend.createValue(path, parameter);
            outputStream.write("".getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.sendException(outputStream, e);
        }
    }
}

