/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.opcua.server;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.basyx.vab.protocol.opcua.server.KeyStoreLoaderClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaSyxOpcUaClientRunner {
    private static Logger logger = LoggerFactory.getLogger(BaSyxOpcUaClientRunner.class);
    private final CompletableFuture<OpcUaClient> future = new CompletableFuture();
    private OpcUaClient client;
    private String endpointUrl;

    public BaSyxOpcUaClientRunner(String endpointUrl) throws Exception {
        this.endpointUrl = endpointUrl;
    }

    private OpcUaClient createClient() throws Exception {
        List endpoints;
        Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "security");
        Files.createDirectories(securityTempDir, new FileAttribute[0]);
        if (!Files.exists(securityTempDir, new LinkOption[0])) {
            throw new Exception("unable to create security dir: " + securityTempDir);
        }
        logger.trace("security temp dir: {}", (Object)securityTempDir.toAbsolutePath());
        KeyStoreLoaderClient loader = new KeyStoreLoaderClient().load(securityTempDir);
        SecurityPolicy securityPolicy = SecurityPolicy.None;
        try {
            endpoints = (List)DiscoveryClient.getEndpoints((String)this.endpointUrl).get();
        }
        catch (Throwable ex) {
            String discoveryUrl = this.endpointUrl;
            if (!discoveryUrl.endsWith("/")) {
                discoveryUrl = discoveryUrl + "/";
            }
            discoveryUrl = discoveryUrl + "discovery";
            logger.trace("Trying explicit discovery URL: {}", (Object)discoveryUrl);
            endpoints = (List)DiscoveryClient.getEndpoints((String)discoveryUrl).get();
        }
        EndpointDescription endpoint = endpoints.stream().filter(e -> e.getSecurityPolicyUri().equals(securityPolicy.getUri())).filter(e -> true).findFirst().orElseThrow(() -> new Exception("no desired endpoints returned"));
        logger.trace("Using endpoint: {} [{}/{}]", new Object[]{endpoint.getEndpointUrl(), securityPolicy, endpoint.getSecurityMode()});
        OpcUaClientConfig config = OpcUaClientConfig.builder().setApplicationName(LocalizedText.english((String)"eclipse milo opc-ua client")).setApplicationUri("urn:eclipse:milo:examples:client").setCertificate(loader.getClientCertificate()).setKeyPair(loader.getClientKeyPair()).setEndpoint(endpoint).setIdentityProvider((IdentityProvider)new AnonymousProvider()).setRequestTimeout(Unsigned.uint((int)5000)).build();
        return OpcUaClient.create((OpcUaClientConfig)config);
    }

    public void run() {
        try {
            this.client = this.createClient();
            this.future.whenCompleteAsync((c, ex) -> {
                if (ex != null) {
                    logger.error("Error running example: {}", (Object)ex.getMessage(), ex);
                }
                try {
                    this.client.disconnect().get();
                    Stack.releaseSharedResources();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Error disconnecting:", (Object)e.getMessage(), (Object)e);
                }
                try {
                    Thread.sleep(1000L);
                    throw new RuntimeException("Could not disconnect from server '" + this.endpointUrl + "'");
                }
                catch (InterruptedException e) {
                    logger.error("Exception in run", (Throwable)e);
                    return;
                }
            });
            this.client.connect().get();
        }
        catch (Throwable t) {
            logger.error("Error getting client: {}", (Object)t.getMessage(), (Object)t);
            this.future.completeExceptionally(t);
            try {
                Thread.sleep(1000L);
                throw new RuntimeException("Could not connect to server '" + this.endpointUrl + "'");
            }
            catch (InterruptedException e) {
                logger.error("Exception in run", (Throwable)e);
            }
        }
    }

    public CompletableFuture<List<DataValue>> read(List<NodeId> nodeIds) {
        return this.client.readValues(0.0, TimestampsToReturn.Both, nodeIds);
    }

    public CompletableFuture<List<StatusCode>> write(List<NodeId> nodeIds, List<DataValue> values) {
        return this.client.writeValues(nodeIds, values);
    }

    public CompletableFuture<CallResponse> callMethod(NodeId objectId, NodeId methodId, Variant[] inputArguments) {
        ArrayList<CallMethodRequest> cmr = new ArrayList<CallMethodRequest>();
        cmr.add(new CallMethodRequest(objectId, methodId, inputArguments));
        return this.client.call(cmr);
    }

    public CompletableFuture<TranslateBrowsePathsToNodeIdsResponse> translate(List<BrowsePath> browsePaths) {
        return this.client.translateBrowsePaths(browsePaths);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

