/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.basyx;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.RelationshipElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxReference;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElement;
import de.iip_ecosphere.platform.support.aas.basyx.BaSyxSubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.basyx.Tools;
import java.util.Map;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;

public class BaSyxRelationshipElement
extends BaSyxSubmodelElement
implements RelationshipElement {
    private org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement relationship;

    public BaSyxRelationshipElement() {
    }

    public BaSyxRelationshipElement(org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement relationship) {
        this.relationship = relationship;
    }

    public String getIdShort() {
        return this.relationship.getIdShort();
    }

    public void accept(AasVisitor visitor) {
        visitor.visitRelationshipElement((RelationshipElement)this);
    }

    @Override
    ISubmodelElement getSubmodelElement() {
        return this.relationship;
    }

    public String getSemanticId(boolean stripPrefix) {
        return Tools.translateReference(this.relationship.getSemanticId(), stripPrefix);
    }

    public Map<String, LangString> getDescription() {
        return Tools.translate(this.relationship.getDescription());
    }

    public Reference getFirst() {
        try {
            return new BaSyxReference(this.relationship.getFirst());
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public Reference getSecond() {
        try {
            return new BaSyxReference(this.relationship.getSecond());
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public void setSemanticId(String semanticId) {
        IReference ref = Tools.translateReference(semanticId);
        if (ref != null) {
            this.relationship.setSemanticId(ref);
        }
    }

    public static class BaSyxRelationshipElementBuilder
    implements RelationshipElement.RelationshipElementBuilder {
        private BaSyxSubmodelElementContainerBuilder<?> parentBuilder;
        private BaSyxRelationshipElement instance;

        BaSyxRelationshipElementBuilder(BaSyxSubmodelElementContainerBuilder<?> parentBuilder, String idShort, Reference first, Reference second) {
            if (!(first instanceof BaSyxReference)) {
                throw new IllegalArgumentException("first reference not instanceof BaSyxReference");
            }
            if (!(second instanceof BaSyxReference)) {
                throw new IllegalArgumentException("second reference not instanceof BaSyxReference");
            }
            this.parentBuilder = parentBuilder;
            this.instance = new BaSyxRelationshipElement();
            this.instance.relationship = new org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.RelationshipElement(Tools.checkId(idShort), ((BaSyxReference)first).getReference(), ((BaSyxReference)second).getReference());
        }

        public RelationshipElement.RelationshipElementBuilder setDescription(LangString ... description) {
            this.instance.relationship.setDescription(Tools.translate(description));
            return this;
        }

        public RelationshipElement.RelationshipElementBuilder setSemanticId(String refValue) {
            IReference ref = Tools.translateReference(refValue);
            if (ref != null) {
                this.instance.relationship.setSemanticId(ref);
            }
            return this;
        }

        public RelationshipElement build() {
            return this.parentBuilder.register(this.instance);
        }
    }
}

