/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.directory.tagged.map;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.registration.memory.AASRegistry;
import org.eclipse.basyx.aas.registration.memory.MapRegistryHandler;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.IAASTaggedDirectory;
import org.eclipse.basyx.extensions.aas.directory.tagged.api.TaggedAASDescriptor;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;

public class MapTaggedDirectory
extends AASRegistry
implements IAASTaggedDirectory {
    private Map<String, Set<TaggedAASDescriptor>> tagMap;

    public MapTaggedDirectory(Map<String, AASDescriptor> rootMap, Map<String, Set<TaggedAASDescriptor>> tagMap) {
        super(new MapRegistryHandler(rootMap));
        this.tagMap = tagMap;
    }

    @Override
    public void register(TaggedAASDescriptor descriptor) {
        super.register(descriptor);
        this.addTags(descriptor.getTags(), descriptor);
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTag(String tag) {
        if (this.tagMap.containsKey(tag)) {
            return this.tagMap.get(tag);
        }
        return new HashSet<TaggedAASDescriptor>();
    }

    @Override
    public Set<TaggedAASDescriptor> lookupTags(Set<String> tags) {
        Set<TaggedAASDescriptor> result = new HashSet<TaggedAASDescriptor>();
        Set descriptors = tags.stream().map(t -> this.lookupTag((String)t)).collect(Collectors.toSet());
        if (descriptors.size() > 0) {
            Iterator it = descriptors.iterator();
            result = (Set)it.next();
            while (it.hasNext()) {
                result.retainAll((Collection)it.next());
            }
        }
        return result;
    }

    @Override
    public void delete(IIdentifier aasIdentifier) {
        AASDescriptor desc = super.lookupAAS(aasIdentifier);
        super.delete(aasIdentifier);
        if (desc instanceof TaggedAASDescriptor) {
            ((TaggedAASDescriptor)desc).getTags().stream().forEach(t -> this.tagMap.get(t).remove(desc));
        }
    }

    private void addTags(Set<String> tags, TaggedAASDescriptor descriptor) {
        tags.stream().forEach(t -> this.addTag((String)t, descriptor));
    }

    private synchronized void addTag(String tag, TaggedAASDescriptor descriptor) {
        if (!this.tagMap.containsKey(tag)) {
            this.tagMap.put(tag, new HashSet());
        }
        this.tagMap.get(tag).add(descriptor);
    }
}

