/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IAsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperation;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.operation.IOperationVariable;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.HasDataSpecification;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.LangStrings;
import org.eclipse.basyx.submodel.metamodel.map.qualifier.Referable;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.AsyncInvocation;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.operation.OperationVariable;
import org.eclipse.basyx.vab.exception.provider.WrongNumberOfParametersException;

public class Operation
extends SubmodelElement
implements IOperation {
    public static final int DEFAULT_ASYNC_TIMEOUT = 10000;
    public static final String IN = "inputVariables";
    public static final String OUT = "outputVariables";
    public static final String INOUT = "inoutputVariables";
    public static final String INVOKABLE = "invokable";
    public static final String MODELTYPE = "Operation";
    public static final String INVOKE = "invoke";

    public Operation() {
        this.putAll(new ModelType(MODELTYPE));
        this.put(IN, new ArrayList());
        this.put(OUT, new ArrayList());
        this.put(INOUT, new ArrayList());
    }

    public Operation(String idShort) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
        this.setInputVariables(new ArrayList<OperationVariable>());
        this.setOutputVariables(new ArrayList<OperationVariable>());
        this.setInOutputVariables(new ArrayList<OperationVariable>());
    }

    public Operation(Collection<OperationVariable> in, Collection<OperationVariable> out, Collection<OperationVariable> inout, Function<Object[], Object> function) {
        this.putAll(new ModelType(MODELTYPE));
        this.put(IN, in);
        this.put(OUT, out);
        this.put(INOUT, inout);
        this.put(INVOKABLE, function);
    }

    public Operation(Function<Object[], Object> function) {
        this();
        this.setInvokable(function);
    }

    public static Operation createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!Operation.isValid(obj)) {
            throw new MetamodelConstructionException(Operation.class, obj);
        }
        Operation ret = new Operation();
        ret.setMap(obj);
        return ret;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj);
    }

    public static boolean isOperation(Object value) {
        if (!(value instanceof Map)) {
            return false;
        }
        Map map = (Map)value;
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(IN) && map.containsKey(OUT) && map.containsKey(INOUT);
    }

    @Override
    public Collection<IOperationVariable> getInputVariables() {
        return this.transformToOperationVariables(this.get(IN));
    }

    @Override
    public Collection<IOperationVariable> getOutputVariables() {
        return this.transformToOperationVariables(this.get(OUT));
    }

    @Override
    public Collection<IOperationVariable> getInOutputVariables() {
        return this.transformToOperationVariables(this.get(INOUT));
    }

    private Collection<IOperationVariable> transformToOperationVariables(Object obj) {
        if (obj instanceof Collection) {
            Collection map = (Collection)obj;
            ArrayList<IOperationVariable> ret = new ArrayList<IOperationVariable>();
            for (Map m : map) {
                ret.add(OperationVariable.createAsFacade(m));
            }
            return ret;
        }
        return new ArrayList<IOperationVariable>();
    }

    @Override
    public Object invoke(Object ... params) {
        if (params.length != this.getInputVariables().size()) {
            throw new WrongNumberOfParametersException(this.getIdShort(), this.getInputVariables(), params);
        }
        return ((Function)this.get(INVOKABLE)).apply(params);
    }

    @Override
    public SubmodelElement[] invoke(SubmodelElement ... elems) {
        throw new UnsupportedOperationException("SubmodelElement matching logic is only supported for connected Operations");
    }

    @Override
    public AsyncInvocation invokeAsync(Object ... params) {
        return new AsyncInvocation(this, 10000, params);
    }

    @Override
    public IAsyncInvocation invokeAsyncWithTimeout(int timeout, Object ... params) {
        return new AsyncInvocation(this, timeout, params);
    }

    public void setInputVariables(Collection<OperationVariable> in) {
        this.put(IN, in);
    }

    public void setOutputVariables(Collection<OperationVariable> out) {
        this.put(OUT, out);
    }

    public void setInOutputVariables(Collection<OperationVariable> inOut) {
        this.put(INOUT, inOut);
    }

    public void setInvokable(Function<Object[], Object> endpoint) {
        this.put(INVOKABLE, endpoint);
    }

    @Override
    public Collection<IReference> getDataSpecificationReferences() {
        return HasDataSpecification.createAsFacade(this).getDataSpecificationReferences();
    }

    @Override
    public void setDataSpecificationReferences(Collection<IReference> ref) {
        HasDataSpecification.createAsFacade(this).setDataSpecificationReferences(ref);
    }

    @Override
    public String getIdShort() {
        return Referable.createAsFacade(this, this.getKeyElement()).getIdShort();
    }

    @Override
    public String getCategory() {
        return Referable.createAsFacade(this, this.getKeyElement()).getCategory();
    }

    @Override
    public LangStrings getDescription() {
        return Referable.createAsFacade(this, this.getKeyElement()).getDescription();
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.OPERATION;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("An Operation has no value");
    }

    @Override
    public Operation getLocalCopy() {
        Operation copy = new Operation();
        copy.putAll(this);
        Collection<IOperationVariable> inVars = copy.getInputVariables();
        ArrayList<OperationVariable> inVarCopy = new ArrayList<OperationVariable>();
        inVars.stream().forEach((? super T v) -> inVarCopy.add(new OperationVariable(v.getValue().getLocalCopy())));
        copy.setInputVariables(inVarCopy);
        Collection<IOperationVariable> outVars = copy.getOutputVariables();
        ArrayList<OperationVariable> outVarCopy = new ArrayList<OperationVariable>();
        outVars.stream().forEach((? super T v) -> outVarCopy.add(new OperationVariable(v.getValue().getLocalCopy())));
        copy.setOutputVariables(outVarCopy);
        Collection<IOperationVariable> inoutVars = copy.getInOutputVariables();
        ArrayList<OperationVariable> inoutVarCopy = new ArrayList<OperationVariable>();
        inoutVars.stream().forEach((? super T v) -> inoutVarCopy.add(new OperationVariable(v.getValue().getLocalCopy())));
        copy.setInOutputVariables(inoutVarCopy);
        return copy;
    }
}

